// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_PROOFREAD_RESULT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_PROOFREAD_RESULT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;
class ProofreadCorrection;

class MODULES_EXPORT ProofreadResult : public bindings::DictionaryBase {
  
  public:
static ProofreadResult* Create() {
  return MakeGarbageCollected<ProofreadResult>();
}
static ProofreadResult* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<ProofreadResult>(isolate);
}
static ProofreadResult* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  ProofreadResult();
explicit  ProofreadResult(v8::Isolate* isolate);

bool hasCorrectedInput() const {
  return has_corrected_input_;
}
const String& correctedInput() const {
  DCHECK(hasCorrectedInput());
return member_corrected_input_;
}
String getCorrectedInputOr(const String& fallback_value) const;
String getCorrectedInputOr(String&& fallback_value) const;
void setCorrectedInput(const String& value);
void setCorrectedInput(String&& value);

bool hasCorrections() const {
  return has_corrections_;
}
const HeapVector<Member<ProofreadCorrection>>& corrections() const {
  DCHECK(hasCorrections());
return member_corrections_;
}
HeapVector<Member<ProofreadCorrection>> getCorrectionsOr(const HeapVector<Member<ProofreadCorrection>>& fallback_value) const;
HeapVector<Member<ProofreadCorrection>> getCorrectionsOr(HeapVector<Member<ProofreadCorrection>>&& fallback_value) const;
void setCorrections(const HeapVector<Member<ProofreadCorrection>>& value);
void setCorrections(HeapVector<Member<ProofreadCorrection>>&& value);




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_corrected_input_ = false;
bool has_corrections_ = false;

String member_corrected_input_;
HeapVector<Member<ProofreadCorrection>> member_corrections_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_PROOFREAD_RESULT_H_
