// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_PRESENTATION_CONNECTION_CLOSE_EVENT_INIT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_PRESENTATION_CONNECTION_CLOSE_EVENT_INIT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_event_init.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_presentation_connection_close_reason.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT PresentationConnectionCloseEventInit : public EventInit {
  
  public:
static PresentationConnectionCloseEventInit* Create() {
  return MakeGarbageCollected<PresentationConnectionCloseEventInit>();
}
static PresentationConnectionCloseEventInit* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<PresentationConnectionCloseEventInit>(isolate);
}
static PresentationConnectionCloseEventInit* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  PresentationConnectionCloseEventInit();
explicit  PresentationConnectionCloseEventInit(v8::Isolate* isolate);

bool hasMessage() const {
  return has_message_;
}
const String& message() const {
  DCHECK(hasMessage());
return member_message_;
}
String getMessageOr(const String& fallback_value) const;
String getMessageOr(String&& fallback_value) const;
void setMessage(const String& value);
void setMessage(String&& value);

bool hasReason() const {
  return true;
}
V8PresentationConnectionCloseReason reason() const {
  return member_reason_;
}
void setReason(V8PresentationConnectionCloseReason value) {
  member_reason_ = value;
}
void setReason(V8PresentationConnectionCloseReason::Enum value) {
  member_reason_ = V8PresentationConnectionCloseReason(value);
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = EventInit::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_message_ = false;

String member_message_;
V8PresentationConnectionCloseReason member_reason_{static_cast<V8PresentationConnectionCloseReason::Enum>(0)};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_PRESENTATION_CONNECTION_CLOSE_EVENT_INIT_H_
