// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_plugin_array.h"

#include "third_party/blink/public/mojom/origin_trials/origin_trial_feature.mojom-shared.h"
#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/is_return_type_compatible.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_set_return_value_for_core.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_plugin.h"
#include "third_party/blink/renderer/core/execution_context/execution_context.h"
#include "third_party/blink/renderer/modules/plugins/dom_plugin.h"
#include "third_party/blink/renderer/modules/plugins/dom_plugin_array.h"
#include "third_party/blink/renderer/platform/bindings/active_script_wrappable_base.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/idl_member_installer.h"
#include "third_party/blink/renderer/platform/bindings/runtime_call_stats.h"
#include "third_party/blink/renderer/platform/bindings/v8_binding.h"
#include "third_party/blink/renderer/platform/bindings/wrapper_type_info.h"

namespace blink {



bool V8PluginArray::IsExposed(ExecutionContext* execution_context) {
  
return execution_context->IsWindow();
}

// Construction of WrapperTypeInfo may require non-trivial initialization due
// to cross-component address resolution in order to load the pointer to the
// parent interface's WrapperTypeInfo.  We ignore this issue because the issue
// happens only on component builds and the official release builds
// (statically-linked builds) are never affected by this issue.
#if defined(COMPONENT_BUILD) && defined(WIN32) && defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wglobal-constructors"
#endif

const WrapperTypeInfo V8PluginArray::wrapper_type_info_{
    {gin::kEmbedderBlink},
    V8PluginArray::InstallInterfaceTemplate,
    nullptr,
    "PluginArray",
    nullptr,
    V8PluginArray::kThisTag,
    V8PluginArray::kMaxSubclassTag,
    WrapperTypeInfo::kWrapperTypeObjectPrototype,
    WrapperTypeInfo::kObjectClassId,
    WrapperTypeInfo::kIdlInterface,
    false,
};

#if defined(COMPONENT_BUILD) && defined(WIN32) && defined(__clang__)
#pragma clang diagnostic pop
#endif

const WrapperTypeInfo& DOMPluginArray::wrapper_type_info_ =
    V8PluginArray::wrapper_type_info_;

// non-[ActiveScriptWrappable]
static_assert(
    !std::is_base_of<ActiveScriptWrappableBase, DOMPluginArray>::value,
    "DOMPluginArray inherits from ActiveScriptWrappable<> without "
    "[ActiveScriptWrappable] extended attribute.");

v8::Intercepted V8PluginArray::NamedPropertyGetterCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DOMPluginArray_NamedPropertyGetter");

// LegacyPlatformObjectGetOwnProperty
// https://webidl.spec.whatwg.org/#LegacyPlatformObjectGetOwnProperty
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.HolderV2();
DOMPluginArray* blink_receiver = V8PluginArray::ToWrappableUnsafe(isolate, v8_receiver);

// Fast path for when the receiver doesn't have any named properties, possibly
// avoiding any parameter conversions.
if (!bindings::HasAnyNamedProperties(blink_receiver)) {    return v8::Intercepted::kNo;}
// "If the result of running the named property visibility
//  algorithm with property name P and object O is true, then:"
const AtomicString& blink_property_name = ToCoreAtomicString(isolate, v8_property_name);
auto&& return_value = blink_receiver->namedItem(blink_property_name);
static_assert(bindings::IsReturnTypeCompatible<IDLNullable<DOMPlugin>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
if (!return_value) {
  // "Return OrdinaryGetOwnProperty(O, P)."
return v8::Intercepted::kNo;
}

// "If operation was defined without an identifier, then set value to the result
//  of performing the steps listed in the interface description to determine the
//  value of a named property with P as the name."
// "Otherwise, operation was defined with an identifier. Set value to the result
//  of performing the steps listed in the description of operation with P as the
//  only argument value."
bindings::V8SetReturnValue(info, return_value, blink_receiver);
return v8::Intercepted::kYes;
}

v8::Intercepted V8PluginArray::NamedPropertySetterCallback(v8::Local<v8::Name> v8_property_name, v8::Local<v8::Value> v8_property_value, const v8::PropertyCallbackInfo<void>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DOMPluginArray_NamedPropertySetter");

// 3.9.2. [[Set]]
// https://webidl.spec.whatwg.org/#legacy-platform-object-set
// step 3. Perform ? OrdinarySetWithOwnDescriptor(O, P, V, Receiver, ownDesc).
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.HolderV2();
DOMPluginArray* blink_receiver = V8PluginArray::ToWrappableUnsafe(isolate, v8_receiver);
const AtomicString& blink_property_name = ToCoreAtomicString(isolate, v8_property_name);
ExceptionState exception_state(isolate);
bool does_exist = blink_receiver->NamedPropertyQuery(blink_property_name, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return v8::Intercepted::kYes;
}
if (does_exist) {
  if (info.ShouldThrowOnError()) {
  V8ThrowException::ThrowTypeError(isolate, "Named property setter is not supported.");
}
return v8::Intercepted::kYes;
}
// Do not intercept. Fallback and let it define a new own property.
return v8::Intercepted::kNo;

}

v8::Intercepted V8PluginArray::NamedPropertyDeleterCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Boolean>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DOMPluginArray_NamedPropertyDeleter");

// 3.9.4. [[Delete]]
// https://webidl.spec.whatwg.org/#legacy-platform-object-delete
// step 2. If O supports named properties, O does not implement an interface
//   with the [Global] extended attribute and the result of calling the
//   named property visibility algorithm with property name P and object O
//   is true, then:
// step 2.1. If O does not implement an interface with a named property
//   deleter, then return false.
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.HolderV2();
DOMPluginArray* blink_receiver = V8PluginArray::ToWrappableUnsafe(isolate, v8_receiver);
const AtomicString& blink_property_name = ToCoreAtomicString(isolate, v8_property_name);
ExceptionState exception_state(isolate);
bool does_exist = blink_receiver->NamedPropertyQuery(blink_property_name, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return v8::Intercepted::kYes;
}
if (does_exist) {
  bindings::V8SetReturnValue(info, false);
if (info.ShouldThrowOnError()) {
  V8ThrowException::ThrowTypeError(isolate, "Named property deleter is not supported.");
}
return v8::Intercepted::kYes;
}

// Do not intercept.
return v8::Intercepted::kNo;
}

v8::Intercepted V8PluginArray::NamedPropertyDefinerCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyDescriptor& v8_property_desc, const v8::PropertyCallbackInfo<void>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DOMPluginArray_NamedPropertyDefiner");

// 3.9.3. [[DefineOwnProperty]]
// https://webidl.spec.whatwg.org/#legacy-platform-object-defineownproperty
// step 2.1. Let creating be true if P is not a supported property name, and
//   false otherwise.
// step 2.2.1. If creating is false and O does not implement an interface
//   with a named property setter, then return false.
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.HolderV2();
DOMPluginArray* blink_receiver = V8PluginArray::ToWrappableUnsafe(isolate, v8_receiver);
const AtomicString& blink_property_name = ToCoreAtomicString(isolate, v8_property_name);
ExceptionState exception_state(isolate);
bool does_exist = blink_receiver->NamedPropertyQuery(blink_property_name, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return v8::Intercepted::kYes;
}
if (does_exist) {
  if (info.ShouldThrowOnError()) {
  V8ThrowException::ThrowTypeError(isolate, "Named property setter is not supported.");
}
return v8::Intercepted::kYes;
}

// Do not intercept. Fallback to OrdinaryDefineOwnProperty.
return v8::Intercepted::kNo;

}

v8::Intercepted V8PluginArray::NamedPropertyDescriptorCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DOMPluginArray_NamedPropertyDescriptor");

// LegacyPlatformObjectGetOwnProperty
// https://webidl.spec.whatwg.org/#LegacyPlatformObjectGetOwnProperty

// "If the result of running the named property visibility algorithm with
//  property name P and object O is true, then:"
v8::Local<v8::Object> v8_receiver = info.HolderV2();
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
if (v8_receiver->GetRealNamedPropertyAttributesInPrototypeChain(
        current_context, v8_property_name).IsJust()) {
  // Do not intercept.  Fallback to OrdinaryGetOwnProperty.
  return v8::Intercepted::kNo;
}

// "If operation was defined without an identifier, then set value to the result
//  of performing the steps listed in the interface description to determine the
//  value of a named property with P as the name."
// "Otherwise, operation was defined with an identifier. Set value to the result
//  of performing the steps listed in the description of operation with P as the
//  only argument value."
auto intercepted =
    V8PluginArray::NamedPropertyGetterCallback(v8_property_name, info);
// "Return OrdinaryGetOwnProperty(O, P)."
if (intercepted == v8::Intercepted::kNo) {
  // Do not intercept.  Fallback to OrdinaryGetOwnProperty.
  return v8::Intercepted::kNo;
}

// "Let desc be a newly created Property Descriptor with no fields."
// "Set desc.[[Value]] to the result of converting value to an ECMAScript
//  value."
// "If O implements an interface with a named property setter, then set
//  desc.[[Writable]] to true, otherwise set it to false."
// "If O implements an interface with the [LegacyUnenumerableNamedProperties]
//  extended attribute, then set desc.[[Enumerable]] to false, otherwise set
//  it to true."
// "Set desc.[[Configurable]] to true."
// "Return desc."
v8::Local<v8::Value> v8_value = info.GetReturnValue().Get();
v8::PropertyDescriptor desc(v8_value, /*writable=*/false);
desc.set_enumerable(false);
desc.set_configurable(true);
bindings::V8SetReturnValue(info, desc);
return v8::Intercepted::kYes;

}

v8::Intercepted V8PluginArray::NamedPropertyQueryCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Integer>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DOMPluginArray_NamedPropertyQuery");

v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.HolderV2();
DOMPluginArray* blink_receiver = V8PluginArray::ToWrappableUnsafe(isolate, v8_receiver);
const AtomicString& blink_property_name = ToCoreAtomicString(isolate, v8_property_name);
ExceptionState exception_state(isolate);
bool does_exist = blink_receiver->NamedPropertyQuery(blink_property_name, exception_state);
if (!does_exist) {
  return v8::Intercepted::kNo;
}
bindings::V8SetReturnValue(info, uint32_t(v8::ReadOnly | v8::DontEnum));
return v8::Intercepted::kYes;
}

void V8PluginArray::NamedPropertyEnumeratorCallback(const v8::PropertyCallbackInfo<v8::Array>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DOMPluginArray_NamedPropertyEnumerator");

// 3.9.6. [[OwnPropertyKeys]]
// https://webidl.spec.whatwg.org/#legacy-platform-object-ownpropertykeys
// step 3. If O supports named properties, then for each P of O's supported
//   property names that is visible according to the named property
//   visibility algorithm, append P to keys.
Vector<String> blink_property_names;
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.HolderV2();
DOMPluginArray* blink_receiver = V8PluginArray::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
blink_receiver->NamedPropertyEnumerator(blink_property_names, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
bindings::V8SetReturnValue(
    info,
    ToV8Traits<IDLSequence<IDLString>>::ToV8(script_state,
                                             blink_property_names)
         .As<v8::Array>());

}

v8::Intercepted V8PluginArray::IndexedPropertyGetterCallback(uint32_t index, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DOMPluginArray_IndexedPropertyGetter");

// LegacyPlatformObjectGetOwnProperty
// https://webidl.spec.whatwg.org/#LegacyPlatformObjectGetOwnProperty
// step 1.2. If index is a supported property index, then:
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.HolderV2();
DOMPluginArray* blink_receiver = V8PluginArray::ToWrappableUnsafe(isolate, v8_receiver);
if (index >= blink_receiver->length()) {
  // step 3. Return OrdinaryGetOwnProperty(O, P).
// Do not intercept.  Fallback to OrdinaryGetOwnProperty.
return v8::Intercepted::kNo;
}
auto&& return_value = blink_receiver->item(index);
static_assert(bindings::IsReturnTypeCompatible<IDLNullable<DOMPlugin>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
return v8::Intercepted::kYes;
}

v8::Intercepted V8PluginArray::IndexedPropertySetterCallback(uint32_t index, v8::Local<v8::Value> v8_property_value, const v8::PropertyCallbackInfo<void>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DOMPluginArray_IndexedPropertySetter");

// 3.9.2. [[Set]]
// https://webidl.spec.whatwg.org/#legacy-platform-object-set
// OrdinarySetWithOwnDescriptor will end up calling DefineOwnProperty,
// which will fail when the receiver object is this legacy platform
// object.
if (info.ShouldThrowOnError()) {
  v8::Isolate* isolate = info.GetIsolate();
V8ThrowException::ThrowTypeError(isolate, "Indexed property setter is not supported.");
}
return v8::Intercepted::kYes;
}

v8::Intercepted V8PluginArray::IndexedPropertyDeleterCallback(uint32_t index, const v8::PropertyCallbackInfo<v8::Boolean>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DOMPluginArray_IndexedPropertyDeleter");

// 3.9.4. [[Delete]]
// https://webidl.spec.whatwg.org/#legacy-platform-object-delete
// step 1.2. If index is not a supported property index, then return true.
// step 1.3. Return false.
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.HolderV2();
DOMPluginArray* blink_receiver = V8PluginArray::ToWrappableUnsafe(isolate, v8_receiver);
const bool is_supported = index < blink_receiver->length();
bindings::V8SetReturnValue(info, !is_supported);
if (is_supported && info.ShouldThrowOnError()) {
  V8ThrowException::ThrowTypeError(isolate, "Index property deleter is not supported.");
}
return v8::Intercepted::kYes;
}

v8::Intercepted V8PluginArray::IndexedPropertyDefinerCallback(uint32_t index, const v8::PropertyDescriptor& v8_property_desc, const v8::PropertyCallbackInfo<void>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DOMPluginArray_IndexedPropertyDefiner");

// 3.9.3. [[DefineOwnProperty]]
// https://webidl.spec.whatwg.org/#legacy-platform-object-defineownproperty
// step 1.1. If the result of calling IsDataDescriptor(Desc) is false, then
//   return false.
if (v8_property_desc.has_get() || v8_property_desc.has_set()) {
  if (info.ShouldThrowOnError()) {
  v8::Isolate* isolate = info.GetIsolate();
V8ThrowException::ThrowTypeError(isolate,  "Accessor properties are not allowed.");
}
return v8::Intercepted::kYes;
}
// step 1.2. If O does not implement an interface with an indexed property
//   setter, then return false.
if (info.ShouldThrowOnError()) {
  v8::Isolate* isolate = info.GetIsolate();
V8ThrowException::ThrowTypeError(isolate, "Index property setter is not supported.");
}
return v8::Intercepted::kYes;
}

v8::Intercepted V8PluginArray::IndexedPropertyDescriptorCallback(uint32_t index, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DOMPluginArray_IndexedPropertyDescriptor");

// LegacyPlatformObjectGetOwnProperty
// https://webidl.spec.whatwg.org/#LegacyPlatformObjectGetOwnProperty
// step 1.2. If index is a supported property index, then:
// step 1.2.3. If operation was defined without an identifier, then set
//   value to the result of performing the steps listed in the interface
//   description to determine the value of an indexed property with index
//   as the index.
// step 1.2.4. Otherwise, operation was defined with an identifier. Set
//   value to the result of performing the steps listed in the description
//   of operation with index as the only argument value.
auto intercepted =
    V8PluginArray::IndexedPropertyGetterCallback(index, info);
if (intercepted == v8::Intercepted::kNo) {
  // step 3. Return OrdinaryGetOwnProperty(O, P).
  // Do not intercept.  Fallback to OrdinaryGetOwnProperty.
  return v8::Intercepted::kNo;
}
// step 1.2.6. Set desc.[[Value]] to the result of converting value to an
//   ECMAScript value.
// step 1.2.7. If O implements an interface with an indexed property setter,
//   then set desc.[[Writable]] to true, otherwise set it to false.
// step 1.2.8. Set desc.[[Enumerable]] and desc.[[Configurable]] to true.
v8::Local<v8::Value> v8_value = info.GetReturnValue().Get();
v8::PropertyDescriptor desc(v8_value, /*writable=*/false);
desc.set_enumerable(true);
desc.set_configurable(true);
bindings::V8SetReturnValue(info, desc);
return v8::Intercepted::kYes;

}

void V8PluginArray::IndexedPropertyEnumeratorCallback(const v8::PropertyCallbackInfo<v8::Array>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DOMPluginArray_IndexedPropertyEnumerator");

v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.HolderV2();
DOMPluginArray* blink_receiver = V8PluginArray::ToWrappableUnsafe(isolate, v8_receiver);
// 3.9.6. [[OwnPropertyKeys]]
// https://webidl.spec.whatwg.org/#legacy-platform-object-ownpropertykeys
// step 2. If O supports indexed properties, then for each index of O's
//   supported property indices, in ascending numerical order, append
//   ! ToString(index) to keys.
uint32_t length = blink_receiver->length();
v8::Local<v8::Array> array =
    bindings::EnumerateIndexedProperties(isolate, length);
bindings::V8SetReturnValue(info, array);

}


namespace  {

namespace v8_plugin_array {


void LengthAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DOMPluginArray_length_Getter");
BLINK_BINDINGS_TRACE_EVENT("PluginArray.length.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
DOMPluginArray* blink_receiver = V8PluginArray::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->length();
static_assert(bindings::IsReturnTypeCompatible<IDLUnsignedLong, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<uint32_t>());
}


void ItemOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DOMPluginArray_item");
BLINK_BINDINGS_TRACE_EVENT("PluginArray.item");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
DOMPluginArray* blink_receiver = V8PluginArray::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_index = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->item(arg1_index);
static_assert(bindings::IsReturnTypeCompatible<IDLNullable<DOMPlugin>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}

void NamedItemOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DOMPluginArray_namedItem");
BLINK_BINDINGS_TRACE_EVENT("PluginArray.namedItem");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
DOMPluginArray* blink_receiver = V8PluginArray::ToWrappableUnsafe(isolate, v8_receiver);
decltype(NativeValueTraits<IDLString>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg1_name;
if (info[0]->IsString()) [[likely]] {
  arg1_name.Init(isolate, info[0].As<v8::String>());
} else {
  ExceptionState exception_state(isolate);
arg1_name = NativeValueTraits<IDLString>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
auto&& return_value = blink_receiver->namedItem(arg1_name);
static_assert(bindings::IsReturnTypeCompatible<IDLNullable<DOMPlugin>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}

void RefreshOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_DOMPluginArray_refresh");
BLINK_BINDINGS_TRACE_EVENT("PluginArray.refresh");






v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
DOMPluginArray* blink_receiver = V8PluginArray::ToWrappableUnsafe(isolate, v8_receiver);
decltype(NativeValueTraits<IDLBoolean>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg1_reload{false};
if (!info[0]->IsUndefined()) {
  ExceptionState exception_state(isolate);
arg1_reload = NativeValueTraits<IDLBoolean>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
blink_receiver->refresh(arg1_reload);

}


}  // namespace v8_plugin_array

using namespace v8_plugin_array;

}  // namespace 

void V8PluginArray::InstallInterfaceTemplate(v8::Isolate* isolate, const DOMWrapperWorld& world, v8::Local<v8::Template> interface_template) {
  const WrapperTypeInfo* const wrapper_type_info = V8PluginArray::GetWrapperTypeInfo();
v8::Local<v8::FunctionTemplate> interface_function_template = interface_template.As<v8::FunctionTemplate>();
v8::Local<v8::ObjectTemplate> instance_template = interface_function_template->InstanceTemplate();
v8::Local<v8::ObjectTemplate> prototype_template = interface_function_template->PrototypeTemplate();
v8::Local<v8::FunctionTemplate> parent_interface_template;
bindings::SetupIDLInterfaceTemplate(isolate, wrapper_type_info, instance_template, prototype_template, interface_function_template, parent_interface_template);



// Named interceptors
instance_template->SetHandler(
    v8::NamedPropertyHandlerConfiguration(
        V8PluginArray::NamedPropertyGetterCallback,
        V8PluginArray::NamedPropertySetterCallback,
        V8PluginArray::NamedPropertyQueryCallback,
        V8PluginArray::NamedPropertyDeleterCallback,
        V8PluginArray::NamedPropertyEnumeratorCallback,
        V8PluginArray::NamedPropertyDefinerCallback,
        V8PluginArray::NamedPropertyDescriptorCallback,
        v8::Local<v8::Value>(),
        static_cast<v8::PropertyHandlerFlags>(int32_t(v8::PropertyHandlerFlags::kOnlyInterceptStrings) | int32_t(v8::PropertyHandlerFlags::kNonMasking) | int32_t(v8::PropertyHandlerFlags::kHasNoSideEffect))));
// Indexed interceptors
instance_template->SetHandler(
    v8::IndexedPropertyHandlerConfiguration(
        V8PluginArray::IndexedPropertyGetterCallback,
        V8PluginArray::IndexedPropertySetterCallback,
        nullptr,  // query
        V8PluginArray::IndexedPropertyDeleterCallback,
        V8PluginArray::IndexedPropertyEnumeratorCallback,
        V8PluginArray::IndexedPropertyDefinerCallback,
        V8PluginArray::IndexedPropertyDescriptorCallback,
        v8::Local<v8::Value>(),
        v8::PropertyHandlerFlags::kHasNoSideEffect));


// @@iterator for indexed properties
// https://webidl.spec.whatwg.org/#define-the-iteration-methods
prototype_template->SetIntrinsicDataProperty(
    v8::Symbol::GetIterator(isolate), v8::kArrayProto_values, v8::DontEnum);

InstallUnconditionalProperties(isolate, world, instance_template, prototype_template, interface_template);
}

void V8PluginArray::InstallUnconditionalProperties(v8::Isolate* isolate, const DOMWrapperWorld& world, v8::Local<v8::ObjectTemplate> instance_template, v8::Local<v8::ObjectTemplate> prototype_template, v8::Local<v8::Template> interface_template) {
  using bindings::IDLMemberInstaller;

v8::Local<v8::Signature> signature = v8::Local<v8::Signature>::Cast(interface_template);
{
  
static const IDLMemberInstaller::AttributeConfig kAttributeTable[] = {
{"length", LengthAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
};
IDLMemberInstaller::InstallAttributes(isolate, world, instance_template, prototype_template, interface_template, signature, "PluginArray", kAttributeTable);
}





{
  static const IDLMemberInstaller::OperationConfig kOperationTable[] = {
{"item", ItemOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"namedItem", NamedItemOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"refresh", RefreshOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
};
IDLMemberInstaller::InstallOperations(isolate, world, instance_template, prototype_template, interface_template, signature, "PluginArray", kOperationTable);
}



}




}  // namespace blink
