// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_PERIODIC_WAVE_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_PERIODIC_WAVE_OPTIONS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_periodic_wave_constraints.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT PeriodicWaveOptions : public PeriodicWaveConstraints {
  
  public:
static PeriodicWaveOptions* Create() {
  return MakeGarbageCollected<PeriodicWaveOptions>();
}
static PeriodicWaveOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<PeriodicWaveOptions>(isolate);
}
static PeriodicWaveOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  PeriodicWaveOptions();
explicit  PeriodicWaveOptions(v8::Isolate* isolate);

bool hasImag() const {
  return has_imag_;
}
const Vector<float>& imag() const {
  DCHECK(hasImag());
return member_imag_;
}
Vector<float> getImagOr(const Vector<float>& fallback_value) const;
Vector<float> getImagOr(Vector<float>&& fallback_value) const;
void setImag(const Vector<float>& value);
void setImag(Vector<float>&& value);

bool hasReal() const {
  return has_real_;
}
const Vector<float>& real() const {
  DCHECK(hasReal());
return member_real_;
}
Vector<float> getRealOr(const Vector<float>& fallback_value) const;
Vector<float> getRealOr(Vector<float>&& fallback_value) const;
void setReal(const Vector<float>& value);
void setReal(Vector<float>&& value);




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = PeriodicWaveConstraints::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_imag_ = false;
bool has_real_ = false;

Vector<float> member_imag_;
Vector<float> member_real_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_PERIODIC_WAVE_OPTIONS_H_
