// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_PAYMENT_SHIPPING_OPTION_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_PAYMENT_SHIPPING_OPTION_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;
class PaymentCurrencyAmount;

class MODULES_EXPORT PaymentShippingOption : public bindings::DictionaryBase {
  
  public:
static PaymentShippingOption* Create() {
  return MakeGarbageCollected<PaymentShippingOption>();
}
static PaymentShippingOption* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<PaymentShippingOption>(isolate);
}
static PaymentShippingOption* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  PaymentShippingOption();
explicit  PaymentShippingOption(v8::Isolate* isolate);

bool hasAmount() const {
  return true;
}
PaymentCurrencyAmount* amount() const {
  return member_amount_.Get();
}
void setAmount(PaymentCurrencyAmount* value) {
  member_amount_ = value;
DCHECK(member_amount_);
}

bool hasId() const {
  return true;
}
const String& id() const {
  return member_id_;
}
void setId(const String& value);
void setId(String&& value);

bool hasLabel() const {
  return true;
}
const String& label() const {
  return member_label_;
}
void setLabel(const String& value);
void setLabel(String&& value);

bool hasSelected() const {
  return true;
}
bool selected() const {
  return member_selected_;
}
void setSelected(bool value) {
  member_selected_ = value;
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 4;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



Member<PaymentCurrencyAmount> member_amount_;
String member_id_;
String member_label_;
bool member_selected_{false};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_PAYMENT_SHIPPING_OPTION_H_
