// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_PAYMENT_REQUEST_EVENT_INIT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_PAYMENT_REQUEST_EVENT_INIT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_extendable_event_init.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;
class PaymentCurrencyAmount;
class PaymentDetailsModifier;
class PaymentMethodData;
class PaymentOptions;
class PaymentShippingOption;

class MODULES_EXPORT PaymentRequestEventInit : public ExtendableEventInit {
  
  public:
static PaymentRequestEventInit* Create() {
  return MakeGarbageCollected<PaymentRequestEventInit>();
}
static PaymentRequestEventInit* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<PaymentRequestEventInit>(isolate);
}
static PaymentRequestEventInit* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  PaymentRequestEventInit();
explicit  PaymentRequestEventInit(v8::Isolate* isolate);

bool hasInstrumentKey() const {
  return has_instrument_key_;
}
const String& instrumentKey() const {
  DCHECK(hasInstrumentKey());
return member_instrument_key_;
}
String getInstrumentKeyOr(const String& fallback_value) const;
String getInstrumentKeyOr(String&& fallback_value) const;
void setInstrumentKey(const String& value);
void setInstrumentKey(String&& value);

bool hasMethodData() const {
  return has_method_data_;
}
const HeapVector<Member<PaymentMethodData>>& methodData() const {
  DCHECK(hasMethodData());
return member_method_data_;
}
HeapVector<Member<PaymentMethodData>> getMethodDataOr(const HeapVector<Member<PaymentMethodData>>& fallback_value) const;
HeapVector<Member<PaymentMethodData>> getMethodDataOr(HeapVector<Member<PaymentMethodData>>&& fallback_value) const;
void setMethodData(const HeapVector<Member<PaymentMethodData>>& value);
void setMethodData(HeapVector<Member<PaymentMethodData>>&& value);

bool hasModifiers() const {
  return has_modifiers_;
}
const HeapVector<Member<PaymentDetailsModifier>>& modifiers() const {
  DCHECK(hasModifiers());
return member_modifiers_;
}
HeapVector<Member<PaymentDetailsModifier>> getModifiersOr(const HeapVector<Member<PaymentDetailsModifier>>& fallback_value) const;
HeapVector<Member<PaymentDetailsModifier>> getModifiersOr(HeapVector<Member<PaymentDetailsModifier>>&& fallback_value) const;
void setModifiers(const HeapVector<Member<PaymentDetailsModifier>>& value);
void setModifiers(HeapVector<Member<PaymentDetailsModifier>>&& value);

bool hasPaymentOptions() const {
  return has_payment_options_;
}
PaymentOptions* paymentOptions() const {
  DCHECK(hasPaymentOptions());
return member_payment_options_.Get();
}
PaymentOptions* getPaymentOptionsOr(PaymentOptions* fallback_value) const {
  if (!hasPaymentOptions()) {
  return fallback_value;
}
return member_payment_options_.Get();
}
void setPaymentOptions(PaymentOptions* value) {
  member_payment_options_ = value;
has_payment_options_ = true;
DCHECK(member_payment_options_);
}

bool hasPaymentRequestId() const {
  return has_payment_request_id_;
}
const String& paymentRequestId() const {
  DCHECK(hasPaymentRequestId());
return member_payment_request_id_;
}
String getPaymentRequestIdOr(const String& fallback_value) const;
String getPaymentRequestIdOr(String&& fallback_value) const;
void setPaymentRequestId(const String& value);
void setPaymentRequestId(String&& value);

bool hasPaymentRequestOrigin() const {
  return has_payment_request_origin_;
}
const String& paymentRequestOrigin() const {
  DCHECK(hasPaymentRequestOrigin());
return member_payment_request_origin_;
}
String getPaymentRequestOriginOr(const String& fallback_value) const;
String getPaymentRequestOriginOr(String&& fallback_value) const;
void setPaymentRequestOrigin(const String& value);
void setPaymentRequestOrigin(String&& value);

bool hasShippingOptions() const {
  return has_shipping_options_;
}
const HeapVector<Member<PaymentShippingOption>>& shippingOptions() const {
  DCHECK(hasShippingOptions());
return member_shipping_options_;
}
HeapVector<Member<PaymentShippingOption>> getShippingOptionsOr(const HeapVector<Member<PaymentShippingOption>>& fallback_value) const;
HeapVector<Member<PaymentShippingOption>> getShippingOptionsOr(HeapVector<Member<PaymentShippingOption>>&& fallback_value) const;
void setShippingOptions(const HeapVector<Member<PaymentShippingOption>>& value);
void setShippingOptions(HeapVector<Member<PaymentShippingOption>>&& value);

bool hasTopOrigin() const {
  return has_top_origin_;
}
const String& topOrigin() const {
  DCHECK(hasTopOrigin());
return member_top_origin_;
}
String getTopOriginOr(const String& fallback_value) const;
String getTopOriginOr(String&& fallback_value) const;
void setTopOrigin(const String& value);
void setTopOrigin(String&& value);

bool hasTotal() const {
  return has_total_;
}
PaymentCurrencyAmount* total() const {
  DCHECK(hasTotal());
return member_total_.Get();
}
PaymentCurrencyAmount* getTotalOr(PaymentCurrencyAmount* fallback_value) const {
  if (!hasTotal()) {
  return fallback_value;
}
return member_total_.Get();
}
void setTotal(PaymentCurrencyAmount* value) {
  member_total_ = value;
has_total_ = true;
DCHECK(member_total_);
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = ExtendableEventInit::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 9;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_instrument_key_ = false;
bool has_method_data_ = false;
bool has_modifiers_ = false;
bool has_payment_options_ = false;
bool has_payment_request_id_ = false;
bool has_payment_request_origin_ = false;
bool has_shipping_options_ = false;
bool has_top_origin_ = false;
bool has_total_ = false;

String member_instrument_key_;
HeapVector<Member<PaymentMethodData>> member_method_data_;
HeapVector<Member<PaymentDetailsModifier>> member_modifiers_;
Member<PaymentOptions> member_payment_options_;
String member_payment_request_id_;
String member_payment_request_origin_;
HeapVector<Member<PaymentShippingOption>> member_shipping_options_;
String member_top_origin_;
Member<PaymentCurrencyAmount> member_total_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_PAYMENT_REQUEST_EVENT_INIT_H_
