// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_PAYMENT_METHOD_DATA_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_PAYMENT_METHOD_DATA_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/script_value.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT PaymentMethodData : public bindings::DictionaryBase {
  
  public:
static PaymentMethodData* Create() {
  return MakeGarbageCollected<PaymentMethodData>();
}
static PaymentMethodData* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<PaymentMethodData>(isolate);
}
static PaymentMethodData* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  PaymentMethodData();
explicit  PaymentMethodData(v8::Isolate* isolate);

bool hasData() const {
  return has_data_;
}
const ScriptObject& data() const {
  DCHECK(hasData());
return member_data_;
}
ScriptObject getDataOr(const ScriptObject& fallback_value) const {
  if (!hasData()) {
  return fallback_value;
}
return member_data_;
}
void setData(const ScriptObject& value) {
  member_data_ = value;
has_data_ = true;
}

bool hasSupportedMethod() const {
  return true;
}
const String& supportedMethod() const {
  return member_supported_method_;
}
void setSupportedMethod(const String& value);
void setSupportedMethod(String&& value);




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_data_ = false;

ScriptObject member_data_;
String member_supported_method_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_PAYMENT_METHOD_DATA_H_
