// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_PAYER_ERRORS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_PAYER_ERRORS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT PayerErrors : public bindings::InputDictionaryBase {
  
  public:
static PayerErrors* Create() {
  return MakeGarbageCollected<PayerErrors>();
}
static PayerErrors* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<PayerErrors>(isolate);
}
static PayerErrors* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  PayerErrors();
explicit  PayerErrors(v8::Isolate* isolate);

bool hasEmail() const {
  return has_email_;
}
const String& email() const {
  DCHECK(hasEmail());
return member_email_;
}
String getEmailOr(const String& fallback_value) const;
String getEmailOr(String&& fallback_value) const;
void setEmail(const String& value);
void setEmail(String&& value);

bool hasName() const {
  return has_name_;
}
const String& name() const {
  DCHECK(hasName());
return member_name_;
}
String getNameOr(const String& fallback_value) const;
String getNameOr(String&& fallback_value) const;
void setName(const String& value);
void setName(String&& value);

bool hasPhone() const {
  return has_phone_;
}
const String& phone() const {
  DCHECK(hasPhone());
return member_phone_;
}
String getPhoneOr(const String& fallback_value) const;
String getPhoneOr(String&& fallback_value) const;
void setPhone(const String& value);
void setPhone(String&& value);




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 3;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_email_ = false;
bool has_name_ = false;
bool has_phone_ = false;

String member_email_;
String member_name_;
String member_phone_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_PAYER_ERRORS_H_
