// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_paint_callback.h"

#include <tuple>

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/callback_invoke_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/core/css/cssom/css_style_value.h"
#include "third_party/blink/renderer/core/css/cssom/style_property_map_read_only.h"
#include "third_party/blink/renderer/modules/csspaint/paint_rendering_context_2d.h"
#include "third_party/blink/renderer/modules/csspaint/paint_size.h"

namespace blink {





const char* V8PaintCallback::GetHumanReadableName() const {
  return "V8PaintCallback";
}

v8::Maybe<void> V8PaintCallback::Invoke(bindings::V8ValueOrScriptWrappableAdapter arg0_receiver, PaintRenderingContext2D* arg1_rendering_context, PaintSize* arg2_paint_size, StylePropertyMapReadOnly* arg3_style_map, const HeapVector<Member<CSSStyleValue>>& arg4_input_arguments) {
  const char* const class_like_name = "PaintCallback";
const char* const property_name = "invoke";
ScriptState* callback_relevant_script_state =
    CallbackRelevantScriptStateOrThrowException(
        class_like_name, property_name);
if (!callback_relevant_script_state) {
  return v8::Nothing<void>();
}

if (!IsCallbackFunctionRunnable(callback_relevant_script_state, IncumbentScriptState())) {
  v8::Isolate* isolate = GetIsolate();
v8::HandleScope handle_scope(isolate);
v8::Context::Scope context_scope(callback_relevant_script_state->GetContext());
V8ThrowException::ThrowError(isolate,"The provided callback is no longer runnable.");
return v8::Nothing<void>();
}

bindings::CallbackInvokeHelper<CallbackFunctionBase, bindings::CallbackInvokeHelperMode::kDefault, bindings::CallbackReturnTypeIsPromise::kNo> helper(
    this, class_like_name, property_name);
if (!helper.PrepareForCall(arg0_receiver)) [[unlikely]] {
  if (helper.V8Result().IsEmpty()) {
  return v8::Nothing<void>();
}
return v8::JustVoid();
}
v8::Local<v8::Value> argv_arr[4];
base::span<v8::Local<v8::Value>> argv(argv_arr);
v8::Local<v8::Value> v8_arg1_rendering_context;
ScriptState* script_state = CallbackRelevantScriptState();
v8_arg1_rendering_context = ToV8Traits<PaintRenderingContext2D>::ToV8(script_state, arg1_rendering_context);
argv[0] = v8_arg1_rendering_context;
v8::Local<v8::Value> v8_arg2_paint_size;
v8_arg2_paint_size = ToV8Traits<PaintSize>::ToV8(script_state, arg2_paint_size);
argv[1] = v8_arg2_paint_size;
v8::Local<v8::Value> v8_arg3_style_map;
v8_arg3_style_map = ToV8Traits<StylePropertyMapReadOnly>::ToV8(script_state, arg3_style_map);
argv[2] = v8_arg3_style_map;
v8::Local<v8::Value> v8_arg4_input_arguments;
v8_arg4_input_arguments = ToV8Traits<IDLSequence<CSSStyleValue>>::ToV8(script_state, arg4_input_arguments);
argv[3] = v8_arg4_input_arguments;
if (!helper.Call(static_cast<int>(argv.size()), argv.data())) {
  return v8::Nothing<void>();
}
return v8::JustVoid();
}

v8::Maybe<void> V8PaintCallback::Construct(PaintRenderingContext2D* arg1_rendering_context, PaintSize* arg2_paint_size, StylePropertyMapReadOnly* arg3_style_map, const HeapVector<Member<CSSStyleValue>>& arg4_input_arguments) {
  const char* const class_like_name = "PaintCallback";
const char* const property_name = "construct";
ScriptState* callback_relevant_script_state =
    CallbackRelevantScriptStateOrThrowException(
        class_like_name, property_name);
if (!callback_relevant_script_state) {
  return v8::Nothing<void>();
}

if (!IsCallbackFunctionRunnable(callback_relevant_script_state, IncumbentScriptState())) {
  v8::Isolate* isolate = GetIsolate();
v8::HandleScope handle_scope(isolate);
v8::Context::Scope context_scope(callback_relevant_script_state->GetContext());
V8ThrowException::ThrowError(isolate,"The provided callback is no longer runnable.");
return v8::Nothing<void>();
}

bindings::CallbackInvokeHelper<CallbackFunctionBase, bindings::CallbackInvokeHelperMode::kConstructorCall, bindings::CallbackReturnTypeIsPromise::kNo> helper(
    this, class_like_name, property_name);
if (!helper.PrepareForCall(nullptr)) [[unlikely]] {
  if (helper.V8Result().IsEmpty()) {
  return v8::Nothing<void>();
}
return v8::JustVoid();
}
v8::Local<v8::Value> argv_arr[4];
base::span<v8::Local<v8::Value>> argv(argv_arr);
v8::Local<v8::Value> v8_arg1_rendering_context;
ScriptState* script_state = CallbackRelevantScriptState();
v8_arg1_rendering_context = ToV8Traits<PaintRenderingContext2D>::ToV8(script_state, arg1_rendering_context);
argv[0] = v8_arg1_rendering_context;
v8::Local<v8::Value> v8_arg2_paint_size;
v8_arg2_paint_size = ToV8Traits<PaintSize>::ToV8(script_state, arg2_paint_size);
argv[1] = v8_arg2_paint_size;
v8::Local<v8::Value> v8_arg3_style_map;
v8_arg3_style_map = ToV8Traits<StylePropertyMapReadOnly>::ToV8(script_state, arg3_style_map);
argv[2] = v8_arg3_style_map;
v8::Local<v8::Value> v8_arg4_input_arguments;
v8_arg4_input_arguments = ToV8Traits<IDLSequence<CSSStyleValue>>::ToV8(script_state, arg4_input_arguments);
argv[3] = v8_arg4_input_arguments;
if (!helper.Call(static_cast<int>(argv.size()), argv.data())) {
  return v8::Nothing<void>();
}
return v8::JustVoid();
}

void V8PaintCallback::InvokeAndReportException(bindings::V8ValueOrScriptWrappableAdapter arg0_receiver, PaintRenderingContext2D* arg1_rendering_context, PaintSize* arg2_paint_size, StylePropertyMapReadOnly* arg3_style_map, const HeapVector<Member<CSSStyleValue>>& arg4_input_arguments) {
  v8::Isolate* isolate = GetIsolate();
v8::TryCatch try_catch(isolate);
try_catch.SetVerbose(true);

std::ignore = Invoke(arg0_receiver, arg1_rendering_context, arg2_paint_size, arg3_style_map, arg4_input_arguments);
}



}  // namespace blink
