// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_OSCILLATOR_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_OSCILLATOR_OPTIONS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_audio_node_options.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_oscillator_type.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class PeriodicWave;

class MODULES_EXPORT OscillatorOptions : public AudioNodeOptions {
  
  public:
static OscillatorOptions* Create() {
  return MakeGarbageCollected<OscillatorOptions>();
}
static OscillatorOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<OscillatorOptions>(isolate);
}
static OscillatorOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  OscillatorOptions();
explicit  OscillatorOptions(v8::Isolate* isolate);

bool hasDetune() const {
  return true;
}
float detune() const {
  return member_detune_;
}
void setDetune(float value) {
  member_detune_ = value;
}

bool hasFrequency() const {
  return true;
}
float frequency() const {
  return member_frequency_;
}
void setFrequency(float value) {
  member_frequency_ = value;
}

bool hasPeriodicWave() const {
  return has_periodic_wave_;
}
PeriodicWave* periodicWave() const {
  DCHECK(hasPeriodicWave());
return member_periodic_wave_.Get();
}
PeriodicWave* getPeriodicWaveOr(PeriodicWave* fallback_value) const {
  if (!hasPeriodicWave()) {
  return fallback_value;
}
return member_periodic_wave_.Get();
}
void setPeriodicWave(PeriodicWave* value) {
  member_periodic_wave_ = value;
has_periodic_wave_ = true;
DCHECK(member_periodic_wave_);
}

bool hasType() const {
  return true;
}
V8OscillatorType type() const {
  return member_type_;
}
void setType(V8OscillatorType value) {
  member_type_ = value;
}
void setType(V8OscillatorType::Enum value) {
  member_type_ = V8OscillatorType(value);
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = AudioNodeOptions::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 4;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_periodic_wave_ = false;

float member_detune_{0};
float member_frequency_{440};
Member<PeriodicWave> member_periodic_wave_;
V8OscillatorType member_type_{V8OscillatorType::Enum::kSine};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_OSCILLATOR_OPTIONS_H_
