// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_NOTIFICATION_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_NOTIFICATION_OPTIONS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/script_value.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_notification_direction.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_notification_scenario.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;
class NotificationAction;
class TimestampTrigger;
class V8UnionUnsignedLongOrUnsignedLongSequence;

class MODULES_EXPORT NotificationOptions : public bindings::InputDictionaryBase {
  
  public:
static NotificationOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<NotificationOptions>(isolate);
}
static NotificationOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  NotificationOptions(v8::Isolate* isolate);

bool hasActions() const {
  return true;
}
const HeapVector<Member<NotificationAction>>& actions() const {
  return member_actions_;
}
void setActions(const HeapVector<Member<NotificationAction>>& value);
void setActions(HeapVector<Member<NotificationAction>>&& value);

bool hasBadge() const {
  return has_badge_;
}
const String& badge() const {
  DCHECK(hasBadge());
return member_badge_;
}
String getBadgeOr(const String& fallback_value) const;
String getBadgeOr(String&& fallback_value) const;
void setBadge(const String& value);
void setBadge(String&& value);

bool hasBody() const {
  return true;
}
const String& body() const {
  return member_body_;
}
void setBody(const String& value);
void setBody(String&& value);

bool hasData() const {
  return true;
}
const ScriptValue& data() const {
  return member_data_;
}
void setData(const ScriptValue& value) {
  member_data_ = value;
}

bool hasDir() const {
  return true;
}
V8NotificationDirection dir() const {
  return member_dir_;
}
void setDir(V8NotificationDirection value) {
  member_dir_ = value;
}
void setDir(V8NotificationDirection::Enum value) {
  member_dir_ = V8NotificationDirection(value);
}

bool hasIcon() const {
  return has_icon_;
}
const String& icon() const {
  DCHECK(hasIcon());
return member_icon_;
}
String getIconOr(const String& fallback_value) const;
String getIconOr(String&& fallback_value) const;
void setIcon(const String& value);
void setIcon(String&& value);

bool hasImage() const {
  return has_image_;
}
const String& image() const {
  DCHECK(hasImage());
return member_image_;
}
String getImageOr(const String& fallback_value) const;
String getImageOr(String&& fallback_value) const;
void setImage(const String& value);
void setImage(String&& value);

bool hasLang() const {
  return true;
}
const String& lang() const {
  return member_lang_;
}
void setLang(const String& value);
void setLang(String&& value);

bool hasRenotify() const {
  return true;
}
bool renotify() const {
  return member_renotify_;
}
void setRenotify(bool value) {
  member_renotify_ = value;
}

bool hasRequireInteraction() const {
  return true;
}
bool requireInteraction() const {
  return member_require_interaction_;
}
void setRequireInteraction(bool value) {
  member_require_interaction_ = value;
}

bool hasScenario() const {
  return true;
}
V8NotificationScenario scenario() const {
  return member_scenario_;
}
void setScenario(V8NotificationScenario value) {
  member_scenario_ = value;
}
void setScenario(V8NotificationScenario::Enum value) {
  member_scenario_ = V8NotificationScenario(value);
}

bool hasShowTrigger() const {
  return has_show_trigger_;
}
TimestampTrigger* showTrigger() const {
  DCHECK(hasShowTrigger());
return member_show_trigger_.Get();
}
TimestampTrigger* getShowTriggerOr(TimestampTrigger* fallback_value) const {
  if (!hasShowTrigger()) {
  return fallback_value;
}
return member_show_trigger_.Get();
}
void setShowTrigger(TimestampTrigger* value) {
  member_show_trigger_ = value;
has_show_trigger_ = true;
DCHECK(member_show_trigger_);
}

bool hasSilent() const {
  return true;
}
bool silent() const {
  return member_silent_;
}
void setSilent(bool value) {
  member_silent_ = value;
}

bool hasTag() const {
  return true;
}
const String& tag() const {
  return member_tag_;
}
void setTag(const String& value);
void setTag(String&& value);

bool hasTimestamp() const {
  return has_timestamp_;
}
uint64_t timestamp() const {
  DCHECK(hasTimestamp());
return member_timestamp_;
}
uint64_t getTimestampOr(uint64_t fallback_value) const {
  if (!hasTimestamp()) {
  return fallback_value;
}
return member_timestamp_;
}
void setTimestamp(uint64_t value) {
  member_timestamp_ = value;
has_timestamp_ = true;
}

bool hasVibrate() const {
  return has_vibrate_;
}
V8UnionUnsignedLongOrUnsignedLongSequence* vibrate() const {
  DCHECK(hasVibrate());
return member_vibrate_.Get();
}
V8UnionUnsignedLongOrUnsignedLongSequence* getVibrateOr(V8UnionUnsignedLongOrUnsignedLongSequence* fallback_value) const {
  if (!hasVibrate()) {
  return fallback_value;
}
return member_vibrate_.Get();
}
void setVibrate(V8UnionUnsignedLongOrUnsignedLongSequence* value) {
  member_vibrate_ = value;
has_vibrate_ = true;
DCHECK(member_vibrate_);
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 16;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_badge_ = false;
bool has_icon_ = false;
bool has_image_ = false;
bool has_show_trigger_ = false;
bool has_timestamp_ = false;
bool has_vibrate_ = false;

HeapVector<Member<NotificationAction>> member_actions_;
String member_badge_;
String member_body_{""};
ScriptValue member_data_;
V8NotificationDirection member_dir_{V8NotificationDirection::Enum::kAuto};
String member_icon_;
String member_image_;
String member_lang_{""};
bool member_renotify_{false};
bool member_require_interaction_{false};
V8NotificationScenario member_scenario_{V8NotificationScenario::Enum::kDefault};
Member<TimestampTrigger> member_show_trigger_;
bool member_silent_{false};
String member_tag_{""};
uint64_t member_timestamp_;
Member<V8UnionUnsignedLongOrUnsignedLongSequence> member_vibrate_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_NOTIFICATION_OPTIONS_H_
