// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_notification_action.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"action",
"icon",
"placeholder",
"title",
"type",
};


}  // namespace 

NotificationAction* NotificationAction::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  NotificationAction* dictionary = MakeGarbageCollected<NotificationAction>(isolate);
if (!v8_value->IsObject()) {
  const char* const class_like_name = "NotificationAction";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 NotificationAction::NotificationAction() {
  
}

 NotificationAction::NotificationAction(v8::Isolate* isolate) {
  
}



void NotificationAction::setAction(const String& value) {
  member_action_ = value;
}

void NotificationAction::setAction(String&& value) {
  member_action_ = std::move(value);
}




String NotificationAction::getIconOr(const String& fallback_value) const {
  if (!hasIcon()) {
  return fallback_value;
}
return member_icon_;
}

String NotificationAction::getIconOr(String&& fallback_value) const {
  if (!hasIcon()) {
  return std::move(fallback_value);
}
return member_icon_;
}

void NotificationAction::setIcon(const String& value) {
  member_icon_ = value;
has_icon_ = true;
}

void NotificationAction::setIcon(String&& value) {
  member_icon_ = std::move(value);
has_icon_ = true;
}




void NotificationAction::setPlaceholder(const String& value) {
  member_placeholder_ = value;
}

void NotificationAction::setPlaceholder(String&& value) {
  member_placeholder_ = std::move(value);
}




void NotificationAction::setTitle(const String& value) {
  member_title_ = value;
}

void NotificationAction::setTitle(String&& value) {
  member_title_ = std::move(value);
}









void NotificationAction::Trace(Visitor* visitor) const {
  bindings::DictionaryBase::Trace(visitor);
}

void NotificationAction::FillTemplateProperties(Vector<std::string_view>& properties) const {
  static_assert(std::size(kOwnPropertyNames) == kOwnPropertyCount);
properties.AppendRange(std::cbegin(kOwnPropertyNames), std::cend(kOwnPropertyNames));
DCHECK_EQ(properties.size(), kTotalPropertyCount);
}

void NotificationAction::FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const {
  CHECK_EQ(kOwnPropertyCount, values.size());
if (hasAction()) {
  values[0] = ToV8Traits<IDLString>::ToV8(script_state, member_action_);
DCHECK(!values[0].IsEmpty());
}
if (hasIcon()) {
  values[1] = ToV8Traits<IDLUSVString>::ToV8(script_state, member_icon_);
DCHECK(!values[1].IsEmpty());
}
if (hasPlaceholder()) {
  values[2] = ToV8Traits<IDLNullable<IDLString>>::ToV8(script_state, member_placeholder_);
DCHECK(!values[2].IsEmpty());
}
if (hasTitle()) {
  values[3] = ToV8Traits<IDLString>::ToV8(script_state, member_title_);
DCHECK(!values[3].IsEmpty());
}
if (hasType()) {
  values[4] = ToV8Traits<V8NotificationActionType>::ToV8(script_state, member_type_);
DCHECK(!values[4].IsEmpty());
}
}

const void* NotificationAction::TemplateKey() const {
  static const void *s_key = &s_key;
return s_key;
}

v8::Local<v8::Object> NotificationAction::FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const {
  v8::MaybeLocal<v8::Value> values[kTotalPropertyCount];
FillValuesImpl(script_state, values);
return dict_template->NewInstance(script_state->GetContext(), values);
}

void NotificationAction::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "NotificationAction";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("action");
constexpr bool is_required = true;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
bool fallback_presence_var;
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), fallback_presence_var, member_action_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("icon");
constexpr bool is_optional = false;
if (!bindings::GetDictionaryMemberFromV8Object<IDLUSVString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_icon_, member_icon_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("placeholder");
if (!bindings::GetDictionaryMemberFromV8Object<IDLNullable<IDLString>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), fallback_presence_var, member_placeholder_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("title");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), fallback_presence_var, member_title_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("type");
if (!bindings::GetDictionaryMemberFromV8Object<V8NotificationActionType, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[4].Get(isolate), fallback_presence_var, member_type_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> NotificationAction::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
