// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_navigation_preload_state.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"enabled",
"headerValue",
};


}  // namespace 

NavigationPreloadState* NavigationPreloadState::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  NavigationPreloadState* dictionary = MakeGarbageCollected<NavigationPreloadState>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "NavigationPreloadState";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 NavigationPreloadState::NavigationPreloadState() {
  
}

 NavigationPreloadState::NavigationPreloadState(v8::Isolate* isolate) {
  
}








String NavigationPreloadState::getHeaderValueOr(const String& fallback_value) const {
  if (!hasHeaderValue()) {
  return fallback_value;
}
return member_header_value_;
}

String NavigationPreloadState::getHeaderValueOr(String&& fallback_value) const {
  if (!hasHeaderValue()) {
  return std::move(fallback_value);
}
return member_header_value_;
}

void NavigationPreloadState::setHeaderValue(const String& value) {
  member_header_value_ = value;
has_header_value_ = true;
}

void NavigationPreloadState::setHeaderValue(String&& value) {
  member_header_value_ = std::move(value);
has_header_value_ = true;
}




void NavigationPreloadState::Trace(Visitor* visitor) const {
  bindings::DictionaryBase::Trace(visitor);
}

void NavigationPreloadState::FillTemplateProperties(Vector<std::string_view>& properties) const {
  static_assert(std::size(kOwnPropertyNames) == kOwnPropertyCount);
properties.AppendRange(std::cbegin(kOwnPropertyNames), std::cend(kOwnPropertyNames));
DCHECK_EQ(properties.size(), kTotalPropertyCount);
}

void NavigationPreloadState::FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const {
  CHECK_EQ(kOwnPropertyCount, values.size());
if (hasEnabled()) {
  values[0] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_enabled_);
DCHECK(!values[0].IsEmpty());
}
if (hasHeaderValue()) {
  values[1] = ToV8Traits<IDLByteString>::ToV8(script_state, member_header_value_);
DCHECK(!values[1].IsEmpty());
}
}

const void* NavigationPreloadState::TemplateKey() const {
  static const void *s_key = &s_key;
return s_key;
}

v8::Local<v8::Object> NavigationPreloadState::FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const {
  v8::MaybeLocal<v8::Value> values[kTotalPropertyCount];
FillValuesImpl(script_state, values);
return dict_template->NewInstance(script_state->GetContext(), values);
}

void NavigationPreloadState::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "NavigationPreloadState";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("enabled");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
bool fallback_presence_var;
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), fallback_presence_var, member_enabled_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("headerValue");
if (!bindings::GetDictionaryMemberFromV8Object<IDLByteString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_header_value_, member_header_value_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> NavigationPreloadState::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
