// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_ML_TRANSPOSE_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_ML_TRANSPOSE_OPTIONS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_ml_operator_options.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT MLTransposeOptions : public MLOperatorOptions {
  
  public:
static MLTransposeOptions* Create() {
  return MakeGarbageCollected<MLTransposeOptions>();
}
static MLTransposeOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<MLTransposeOptions>(isolate);
}
static MLTransposeOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  MLTransposeOptions();
explicit  MLTransposeOptions(v8::Isolate* isolate);

bool hasPermutation() const {
  return has_permutation_;
}
const Vector<uint32_t>& permutation() const {
  DCHECK(hasPermutation());
return member_permutation_;
}
Vector<uint32_t> getPermutationOr(const Vector<uint32_t>& fallback_value) const;
Vector<uint32_t> getPermutationOr(Vector<uint32_t>&& fallback_value) const;
void setPermutation(const Vector<uint32_t>& value);
void setPermutation(Vector<uint32_t>&& value);




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = MLOperatorOptions::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 1;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_permutation_ = false;

Vector<uint32_t> member_permutation_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_ML_TRANSPOSE_OPTIONS_H_
