// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_ML_SLICE_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_ML_SLICE_OPTIONS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_ml_operator_options.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT MLSliceOptions : public MLOperatorOptions {
  
  public:
static MLSliceOptions* Create() {
  return MakeGarbageCollected<MLSliceOptions>();
}
static MLSliceOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<MLSliceOptions>(isolate);
}
static MLSliceOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  MLSliceOptions();
explicit  MLSliceOptions(v8::Isolate* isolate);

bool hasStrides() const {
  return has_strides_;
}
const Vector<uint32_t>& strides() const {
  DCHECK(hasStrides());
return member_strides_;
}
Vector<uint32_t> getStridesOr(const Vector<uint32_t>& fallback_value) const;
Vector<uint32_t> getStridesOr(Vector<uint32_t>&& fallback_value) const;
void setStrides(const Vector<uint32_t>& value);
void setStrides(Vector<uint32_t>&& value);




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = MLOperatorOptions::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 1;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_strides_ = false;

Vector<uint32_t> member_strides_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_ML_SLICE_OPTIONS_H_
