// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_ML_POOL_2D_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_ML_POOL_2D_OPTIONS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_ml_input_operand_layout.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_ml_operator_options.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_ml_rounding_type.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT MLPool2dOptions : public MLOperatorOptions {
  
  public:
static MLPool2dOptions* Create() {
  return MakeGarbageCollected<MLPool2dOptions>();
}
static MLPool2dOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<MLPool2dOptions>(isolate);
}
static MLPool2dOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  MLPool2dOptions();
explicit  MLPool2dOptions(v8::Isolate* isolate);

bool hasDilations() const {
  return has_dilations_;
}
const Vector<uint32_t>& dilations() const {
  DCHECK(hasDilations());
return member_dilations_;
}
Vector<uint32_t> getDilationsOr(const Vector<uint32_t>& fallback_value) const;
Vector<uint32_t> getDilationsOr(Vector<uint32_t>&& fallback_value) const;
void setDilations(const Vector<uint32_t>& value);
void setDilations(Vector<uint32_t>&& value);

bool hasLayout() const {
  return true;
}
V8MLInputOperandLayout layout() const {
  return member_layout_;
}
void setLayout(V8MLInputOperandLayout value) {
  member_layout_ = value;
}
void setLayout(V8MLInputOperandLayout::Enum value) {
  member_layout_ = V8MLInputOperandLayout(value);
}

bool hasOutputSizes() const {
  return has_output_sizes_;
}
const Vector<uint32_t>& outputSizes() const {
  DCHECK(hasOutputSizes());
return member_output_sizes_;
}
Vector<uint32_t> getOutputSizesOr(const Vector<uint32_t>& fallback_value) const;
Vector<uint32_t> getOutputSizesOr(Vector<uint32_t>&& fallback_value) const;
void setOutputSizes(const Vector<uint32_t>& value);
void setOutputSizes(Vector<uint32_t>&& value);

bool hasPadding() const {
  return has_padding_;
}
const Vector<uint32_t>& padding() const {
  DCHECK(hasPadding());
return member_padding_;
}
Vector<uint32_t> getPaddingOr(const Vector<uint32_t>& fallback_value) const;
Vector<uint32_t> getPaddingOr(Vector<uint32_t>&& fallback_value) const;
void setPadding(const Vector<uint32_t>& value);
void setPadding(Vector<uint32_t>&& value);

bool hasRoundingType() const {
  return true;
}
V8MLRoundingType roundingType() const {
  return member_rounding_type_;
}
void setRoundingType(V8MLRoundingType value) {
  member_rounding_type_ = value;
}
void setRoundingType(V8MLRoundingType::Enum value) {
  member_rounding_type_ = V8MLRoundingType(value);
}

bool hasStrides() const {
  return has_strides_;
}
const Vector<uint32_t>& strides() const {
  DCHECK(hasStrides());
return member_strides_;
}
Vector<uint32_t> getStridesOr(const Vector<uint32_t>& fallback_value) const;
Vector<uint32_t> getStridesOr(Vector<uint32_t>&& fallback_value) const;
void setStrides(const Vector<uint32_t>& value);
void setStrides(Vector<uint32_t>&& value);

bool hasWindowDimensions() const {
  return has_window_dimensions_;
}
const Vector<uint32_t>& windowDimensions() const {
  DCHECK(hasWindowDimensions());
return member_window_dimensions_;
}
Vector<uint32_t> getWindowDimensionsOr(const Vector<uint32_t>& fallback_value) const;
Vector<uint32_t> getWindowDimensionsOr(Vector<uint32_t>&& fallback_value) const;
void setWindowDimensions(const Vector<uint32_t>& value);
void setWindowDimensions(Vector<uint32_t>&& value);




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = MLOperatorOptions::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 7;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_dilations_ = false;
bool has_output_sizes_ = false;
bool has_padding_ = false;
bool has_strides_ = false;
bool has_window_dimensions_ = false;

Vector<uint32_t> member_dilations_;
V8MLInputOperandLayout member_layout_{V8MLInputOperandLayout::Enum::kNchw};
Vector<uint32_t> member_output_sizes_;
Vector<uint32_t> member_padding_;
V8MLRoundingType member_rounding_type_{V8MLRoundingType::Enum::kFloor};
Vector<uint32_t> member_strides_;
Vector<uint32_t> member_window_dimensions_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_ML_POOL_2D_OPTIONS_H_
