// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_ml_gru_options.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/modules/ml/webnn/ml_operand.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"activations",
"bias",
"direction",
"initialHiddenState",
"layout",
"recurrentBias",
"resetAfter",
"returnSequence",
};


}  // namespace 

MLGruOptions* MLGruOptions::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  MLGruOptions* dictionary = MakeGarbageCollected<MLGruOptions>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "MLGruOptions";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 MLGruOptions::MLGruOptions() {
  
}

 MLGruOptions::MLGruOptions(v8::Isolate* isolate) : MLOperatorOptions(isolate) {
  
}



Vector<V8MLRecurrentNetworkActivation> MLGruOptions::getActivationsOr(const Vector<V8MLRecurrentNetworkActivation>& fallback_value) const {
  if (!hasActivations()) {
  return fallback_value;
}
return member_activations_;
}

Vector<V8MLRecurrentNetworkActivation> MLGruOptions::getActivationsOr(Vector<V8MLRecurrentNetworkActivation>&& fallback_value) const {
  if (!hasActivations()) {
  return std::move(fallback_value);
}
return member_activations_;
}

void MLGruOptions::setActivations(const Vector<V8MLRecurrentNetworkActivation>& value) {
  member_activations_ = value;
has_activations_ = true;
}

void MLGruOptions::setActivations(Vector<V8MLRecurrentNetworkActivation>&& value) {
  member_activations_ = std::move(value);
has_activations_ = true;
}













































void MLGruOptions::Trace(Visitor* visitor) const {
  visitor->Trace(member_bias_);
visitor->Trace(member_initial_hidden_state_);
visitor->Trace(member_recurrent_bias_);
MLOperatorOptions::Trace(visitor);
}

void MLGruOptions::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
MLOperatorOptions::FillMembersFromV8Object(isolate, v8_dictionary, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

const char* const class_like_name = "MLGruOptions";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("activations");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<V8MLRecurrentNetworkActivation>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_activations_, member_activations_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("bias");
if (!bindings::GetDictionaryMemberFromV8Object<MLOperand, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_bias_, member_bias_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("direction");
bool fallback_presence_var;
if (!bindings::GetDictionaryMemberFromV8Object<V8MLRecurrentNetworkDirection, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), fallback_presence_var, member_direction_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("initialHiddenState");
if (!bindings::GetDictionaryMemberFromV8Object<MLOperand, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), has_initial_hidden_state_, member_initial_hidden_state_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("layout");
if (!bindings::GetDictionaryMemberFromV8Object<V8MLGruWeightLayout, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[4].Get(isolate), fallback_presence_var, member_layout_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("recurrentBias");
if (!bindings::GetDictionaryMemberFromV8Object<MLOperand, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[5].Get(isolate), has_recurrent_bias_, member_recurrent_bias_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("resetAfter");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[6].Get(isolate), fallback_presence_var, member_reset_after_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("returnSequence");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[7].Get(isolate), fallback_presence_var, member_return_sequence_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> MLGruOptions::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
