// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_ML_GEMM_SUPPORT_LIMITS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_ML_GEMM_SUPPORT_LIMITS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class MLTensorLimits;

class MODULES_EXPORT MLGemmSupportLimits : public bindings::DictionaryBase {
  
  public:
static MLGemmSupportLimits* Create() {
  return MakeGarbageCollected<MLGemmSupportLimits>();
}
static MLGemmSupportLimits* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<MLGemmSupportLimits>(isolate);
}
static MLGemmSupportLimits* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  MLGemmSupportLimits();
explicit  MLGemmSupportLimits(v8::Isolate* isolate);

bool hasA() const {
  return has_a_;
}
MLTensorLimits* a() const {
  DCHECK(hasA());
return member_a_.Get();
}
MLTensorLimits* getAOr(MLTensorLimits* fallback_value) const {
  if (!hasA()) {
  return fallback_value;
}
return member_a_.Get();
}
void setA(MLTensorLimits* value) {
  member_a_ = value;
has_a_ = true;
DCHECK(member_a_);
}

bool hasB() const {
  return has_b_;
}
MLTensorLimits* b() const {
  DCHECK(hasB());
return member_b_.Get();
}
MLTensorLimits* getBOr(MLTensorLimits* fallback_value) const {
  if (!hasB()) {
  return fallback_value;
}
return member_b_.Get();
}
void setB(MLTensorLimits* value) {
  member_b_ = value;
has_b_ = true;
DCHECK(member_b_);
}

bool hasC() const {
  return has_c_;
}
MLTensorLimits* c() const {
  DCHECK(hasC());
return member_c_.Get();
}
MLTensorLimits* getCOr(MLTensorLimits* fallback_value) const {
  if (!hasC()) {
  return fallback_value;
}
return member_c_.Get();
}
void setC(MLTensorLimits* value) {
  member_c_ = value;
has_c_ = true;
DCHECK(member_c_);
}

bool hasOutput() const {
  return has_output_;
}
MLTensorLimits* output() const {
  DCHECK(hasOutput());
return member_output_.Get();
}
MLTensorLimits* getOutputOr(MLTensorLimits* fallback_value) const {
  if (!hasOutput()) {
  return fallback_value;
}
return member_output_.Get();
}
void setOutput(MLTensorLimits* value) {
  member_output_ = value;
has_output_ = true;
DCHECK(member_output_);
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 4;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_a_ = false;
bool has_b_ = false;
bool has_c_ = false;
bool has_output_ = false;

Member<MLTensorLimits> member_a_;
Member<MLTensorLimits> member_b_;
Member<MLTensorLimits> member_c_;
Member<MLTensorLimits> member_output_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_ML_GEMM_SUPPORT_LIMITS_H_
