// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_ml_conv_transpose_2d_options.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/modules/ml/webnn/ml_operand.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"bias",
"dilations",
"filterLayout",
"groups",
"inputLayout",
"outputPadding",
"outputSizes",
"padding",
"strides",
};


}  // namespace 

MLConvTranspose2dOptions* MLConvTranspose2dOptions::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  MLConvTranspose2dOptions* dictionary = MakeGarbageCollected<MLConvTranspose2dOptions>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "MLConvTranspose2dOptions";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 MLConvTranspose2dOptions::MLConvTranspose2dOptions() {
  
}

 MLConvTranspose2dOptions::MLConvTranspose2dOptions(v8::Isolate* isolate) : MLOperatorOptions(isolate) {
  
}










Vector<uint32_t> MLConvTranspose2dOptions::getDilationsOr(const Vector<uint32_t>& fallback_value) const {
  if (!hasDilations()) {
  return fallback_value;
}
return member_dilations_;
}

Vector<uint32_t> MLConvTranspose2dOptions::getDilationsOr(Vector<uint32_t>&& fallback_value) const {
  if (!hasDilations()) {
  return std::move(fallback_value);
}
return member_dilations_;
}

void MLConvTranspose2dOptions::setDilations(const Vector<uint32_t>& value) {
  member_dilations_ = value;
has_dilations_ = true;
}

void MLConvTranspose2dOptions::setDilations(Vector<uint32_t>&& value) {
  member_dilations_ = std::move(value);
has_dilations_ = true;
}



















Vector<uint32_t> MLConvTranspose2dOptions::getOutputPaddingOr(const Vector<uint32_t>& fallback_value) const {
  if (!hasOutputPadding()) {
  return fallback_value;
}
return member_output_padding_;
}

Vector<uint32_t> MLConvTranspose2dOptions::getOutputPaddingOr(Vector<uint32_t>&& fallback_value) const {
  if (!hasOutputPadding()) {
  return std::move(fallback_value);
}
return member_output_padding_;
}

void MLConvTranspose2dOptions::setOutputPadding(const Vector<uint32_t>& value) {
  member_output_padding_ = value;
has_output_padding_ = true;
}

void MLConvTranspose2dOptions::setOutputPadding(Vector<uint32_t>&& value) {
  member_output_padding_ = std::move(value);
has_output_padding_ = true;
}




Vector<uint32_t> MLConvTranspose2dOptions::getOutputSizesOr(const Vector<uint32_t>& fallback_value) const {
  if (!hasOutputSizes()) {
  return fallback_value;
}
return member_output_sizes_;
}

Vector<uint32_t> MLConvTranspose2dOptions::getOutputSizesOr(Vector<uint32_t>&& fallback_value) const {
  if (!hasOutputSizes()) {
  return std::move(fallback_value);
}
return member_output_sizes_;
}

void MLConvTranspose2dOptions::setOutputSizes(const Vector<uint32_t>& value) {
  member_output_sizes_ = value;
has_output_sizes_ = true;
}

void MLConvTranspose2dOptions::setOutputSizes(Vector<uint32_t>&& value) {
  member_output_sizes_ = std::move(value);
has_output_sizes_ = true;
}




Vector<uint32_t> MLConvTranspose2dOptions::getPaddingOr(const Vector<uint32_t>& fallback_value) const {
  if (!hasPadding()) {
  return fallback_value;
}
return member_padding_;
}

Vector<uint32_t> MLConvTranspose2dOptions::getPaddingOr(Vector<uint32_t>&& fallback_value) const {
  if (!hasPadding()) {
  return std::move(fallback_value);
}
return member_padding_;
}

void MLConvTranspose2dOptions::setPadding(const Vector<uint32_t>& value) {
  member_padding_ = value;
has_padding_ = true;
}

void MLConvTranspose2dOptions::setPadding(Vector<uint32_t>&& value) {
  member_padding_ = std::move(value);
has_padding_ = true;
}




Vector<uint32_t> MLConvTranspose2dOptions::getStridesOr(const Vector<uint32_t>& fallback_value) const {
  if (!hasStrides()) {
  return fallback_value;
}
return member_strides_;
}

Vector<uint32_t> MLConvTranspose2dOptions::getStridesOr(Vector<uint32_t>&& fallback_value) const {
  if (!hasStrides()) {
  return std::move(fallback_value);
}
return member_strides_;
}

void MLConvTranspose2dOptions::setStrides(const Vector<uint32_t>& value) {
  member_strides_ = value;
has_strides_ = true;
}

void MLConvTranspose2dOptions::setStrides(Vector<uint32_t>&& value) {
  member_strides_ = std::move(value);
has_strides_ = true;
}




void MLConvTranspose2dOptions::Trace(Visitor* visitor) const {
  visitor->Trace(member_bias_);
MLOperatorOptions::Trace(visitor);
}

void MLConvTranspose2dOptions::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
MLOperatorOptions::FillMembersFromV8Object(isolate, v8_dictionary, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

const char* const class_like_name = "MLConvTranspose2dOptions";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("bias");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<MLOperand, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_bias_, member_bias_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("dilations");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<IDLUnsignedLongEnforceRange>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_dilations_, member_dilations_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("filterLayout");
bool fallback_presence_var;
if (!bindings::GetDictionaryMemberFromV8Object<V8MLConvTranspose2dFilterOperandLayout, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), fallback_presence_var, member_filter_layout_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("groups");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLongEnforceRange, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), fallback_presence_var, member_groups_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("inputLayout");
if (!bindings::GetDictionaryMemberFromV8Object<V8MLInputOperandLayout, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[4].Get(isolate), fallback_presence_var, member_input_layout_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("outputPadding");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<IDLUnsignedLongEnforceRange>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[5].Get(isolate), has_output_padding_, member_output_padding_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("outputSizes");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<IDLUnsignedLongEnforceRange>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[6].Get(isolate), has_output_sizes_, member_output_sizes_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("padding");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<IDLUnsignedLongEnforceRange>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[7].Get(isolate), has_padding_, member_padding_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("strides");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<IDLUnsignedLongEnforceRange>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[8].Get(isolate), has_strides_, member_strides_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> MLConvTranspose2dOptions::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
