// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_ML_CLAMP_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_ML_CLAMP_OPTIONS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_ml_operator_options.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/bigint.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class V8UnionBigintOrUnrestrictedDouble;

class MODULES_EXPORT MLClampOptions : public MLOperatorOptions {
  
  public:
static MLClampOptions* Create() {
  return MakeGarbageCollected<MLClampOptions>();
}
static MLClampOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<MLClampOptions>(isolate);
}
static MLClampOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  MLClampOptions();
explicit  MLClampOptions(v8::Isolate* isolate);

bool hasMaxValue() const {
  return has_max_value_;
}
V8UnionBigintOrUnrestrictedDouble* maxValue() const {
  DCHECK(hasMaxValue());
return member_max_value_.Get();
}
V8UnionBigintOrUnrestrictedDouble* getMaxValueOr(V8UnionBigintOrUnrestrictedDouble* fallback_value) const {
  if (!hasMaxValue()) {
  return fallback_value;
}
return member_max_value_.Get();
}
void setMaxValue(V8UnionBigintOrUnrestrictedDouble* value) {
  member_max_value_ = value;
has_max_value_ = true;
DCHECK(member_max_value_);
}

bool hasMinValue() const {
  return has_min_value_;
}
V8UnionBigintOrUnrestrictedDouble* minValue() const {
  DCHECK(hasMinValue());
return member_min_value_.Get();
}
V8UnionBigintOrUnrestrictedDouble* getMinValueOr(V8UnionBigintOrUnrestrictedDouble* fallback_value) const {
  if (!hasMinValue()) {
  return fallback_value;
}
return member_min_value_.Get();
}
void setMinValue(V8UnionBigintOrUnrestrictedDouble* value) {
  member_min_value_ = value;
has_min_value_ = true;
DCHECK(member_min_value_);
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = MLOperatorOptions::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_max_value_ = false;
bool has_min_value_ = false;

Member<V8UnionBigintOrUnrestrictedDouble> member_max_value_;
Member<V8UnionBigintOrUnrestrictedDouble> member_min_value_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_ML_CLAMP_OPTIONS_H_
