// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_MEDIA_TRACK_SETTINGS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_MEDIA_TRACK_SETTINGS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;
class Point2D;
class V8UnionBooleanOrString;

class MODULES_EXPORT MediaTrackSettings : public bindings::DictionaryBase {
  
  public:
static MediaTrackSettings* Create() {
  return MakeGarbageCollected<MediaTrackSettings>();
}
static MediaTrackSettings* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<MediaTrackSettings>(isolate);
}
static MediaTrackSettings* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  MediaTrackSettings();
explicit  MediaTrackSettings(v8::Isolate* isolate);

bool hasAspectRatio() const {
  return has_aspect_ratio_;
}
double aspectRatio() const {
  DCHECK(hasAspectRatio());
return member_aspect_ratio_;
}
double getAspectRatioOr(double fallback_value) const {
  if (!hasAspectRatio()) {
  return fallback_value;
}
return member_aspect_ratio_;
}
void setAspectRatio(double value) {
  member_aspect_ratio_ = value;
has_aspect_ratio_ = true;
}

bool hasAutoGainControl() const {
  return has_auto_gain_control_;
}
bool autoGainControl() const {
  DCHECK(hasAutoGainControl());
return member_auto_gain_control_;
}
bool getAutoGainControlOr(bool fallback_value) const {
  if (!hasAutoGainControl()) {
  return fallback_value;
}
return member_auto_gain_control_;
}
void setAutoGainControl(bool value) {
  member_auto_gain_control_ = value;
has_auto_gain_control_ = true;
}

bool hasBackgroundBlur() const {
  return has_background_blur_;
}
bool backgroundBlur() const {
  DCHECK(hasBackgroundBlur());
return member_background_blur_;
}
bool getBackgroundBlurOr(bool fallback_value) const {
  if (!hasBackgroundBlur()) {
  return fallback_value;
}
return member_background_blur_;
}
void setBackgroundBlur(bool value) {
  member_background_blur_ = value;
has_background_blur_ = true;
}

bool hasBackgroundSegmentationMask() const {
  return has_background_segmentation_mask_;
}
bool backgroundSegmentationMask() const {
  DCHECK(hasBackgroundSegmentationMask());
return member_background_segmentation_mask_;
}
bool getBackgroundSegmentationMaskOr(bool fallback_value) const {
  if (!hasBackgroundSegmentationMask()) {
  return fallback_value;
}
return member_background_segmentation_mask_;
}
void setBackgroundSegmentationMask(bool value) {
  member_background_segmentation_mask_ = value;
has_background_segmentation_mask_ = true;
}

bool hasBrightness() const {
  return has_brightness_;
}
double brightness() const {
  DCHECK(hasBrightness());
return member_brightness_;
}
double getBrightnessOr(double fallback_value) const {
  if (!hasBrightness()) {
  return fallback_value;
}
return member_brightness_;
}
void setBrightness(double value) {
  member_brightness_ = value;
has_brightness_ = true;
}

bool hasChannelCount() const {
  return has_channel_count_;
}
int32_t channelCount() const {
  DCHECK(hasChannelCount());
return member_channel_count_;
}
int32_t getChannelCountOr(int32_t fallback_value) const {
  if (!hasChannelCount()) {
  return fallback_value;
}
return member_channel_count_;
}
void setChannelCount(int32_t value) {
  member_channel_count_ = value;
has_channel_count_ = true;
}

bool hasColorTemperature() const {
  return has_color_temperature_;
}
double colorTemperature() const {
  DCHECK(hasColorTemperature());
return member_color_temperature_;
}
double getColorTemperatureOr(double fallback_value) const {
  if (!hasColorTemperature()) {
  return fallback_value;
}
return member_color_temperature_;
}
void setColorTemperature(double value) {
  member_color_temperature_ = value;
has_color_temperature_ = true;
}

bool hasContrast() const {
  return has_contrast_;
}
double contrast() const {
  DCHECK(hasContrast());
return member_contrast_;
}
double getContrastOr(double fallback_value) const {
  if (!hasContrast()) {
  return fallback_value;
}
return member_contrast_;
}
void setContrast(double value) {
  member_contrast_ = value;
has_contrast_ = true;
}

bool hasCursor() const {
  return has_cursor_;
}
const String& cursor() const {
  DCHECK(hasCursor());
return member_cursor_;
}
String getCursorOr(const String& fallback_value) const;
String getCursorOr(String&& fallback_value) const;
void setCursor(const String& value);
void setCursor(String&& value);

bool hasDeviceId() const {
  return has_device_id_;
}
const String& deviceId() const {
  DCHECK(hasDeviceId());
return member_device_id_;
}
String getDeviceIdOr(const String& fallback_value) const;
String getDeviceIdOr(String&& fallback_value) const;
void setDeviceId(const String& value);
void setDeviceId(String&& value);

bool hasDisplaySurface() const {
  return has_display_surface_;
}
const String& displaySurface() const {
  DCHECK(hasDisplaySurface());
return member_display_surface_;
}
String getDisplaySurfaceOr(const String& fallback_value) const;
String getDisplaySurfaceOr(String&& fallback_value) const;
void setDisplaySurface(const String& value);
void setDisplaySurface(String&& value);

bool hasEchoCancellation() const {
  return has_echo_cancellation_;
}
V8UnionBooleanOrString* echoCancellation() const {
  DCHECK(hasEchoCancellation());
return member_echo_cancellation_.Get();
}
V8UnionBooleanOrString* getEchoCancellationOr(V8UnionBooleanOrString* fallback_value) const {
  if (!hasEchoCancellation()) {
  return fallback_value;
}
return member_echo_cancellation_.Get();
}
void setEchoCancellation(V8UnionBooleanOrString* value) {
  member_echo_cancellation_ = value;
has_echo_cancellation_ = true;
DCHECK(member_echo_cancellation_);
}

bool hasExposureCompensation() const {
  return has_exposure_compensation_;
}
double exposureCompensation() const {
  DCHECK(hasExposureCompensation());
return member_exposure_compensation_;
}
double getExposureCompensationOr(double fallback_value) const {
  if (!hasExposureCompensation()) {
  return fallback_value;
}
return member_exposure_compensation_;
}
void setExposureCompensation(double value) {
  member_exposure_compensation_ = value;
has_exposure_compensation_ = true;
}

bool hasExposureMode() const {
  return has_exposure_mode_;
}
const String& exposureMode() const {
  DCHECK(hasExposureMode());
return member_exposure_mode_;
}
String getExposureModeOr(const String& fallback_value) const;
String getExposureModeOr(String&& fallback_value) const;
void setExposureMode(const String& value);
void setExposureMode(String&& value);

bool hasExposureTime() const {
  return has_exposure_time_;
}
double exposureTime() const {
  DCHECK(hasExposureTime());
return member_exposure_time_;
}
double getExposureTimeOr(double fallback_value) const {
  if (!hasExposureTime()) {
  return fallback_value;
}
return member_exposure_time_;
}
void setExposureTime(double value) {
  member_exposure_time_ = value;
has_exposure_time_ = true;
}

bool hasEyeGazeCorrection() const {
  return has_eye_gaze_correction_;
}
bool eyeGazeCorrection() const {
  DCHECK(hasEyeGazeCorrection());
return member_eye_gaze_correction_;
}
bool getEyeGazeCorrectionOr(bool fallback_value) const {
  if (!hasEyeGazeCorrection()) {
  return fallback_value;
}
return member_eye_gaze_correction_;
}
void setEyeGazeCorrection(bool value) {
  member_eye_gaze_correction_ = value;
has_eye_gaze_correction_ = true;
}

bool hasFaceFraming() const {
  return has_face_framing_;
}
bool faceFraming() const {
  DCHECK(hasFaceFraming());
return member_face_framing_;
}
bool getFaceFramingOr(bool fallback_value) const {
  if (!hasFaceFraming()) {
  return fallback_value;
}
return member_face_framing_;
}
void setFaceFraming(bool value) {
  member_face_framing_ = value;
has_face_framing_ = true;
}

bool hasFacingMode() const {
  return has_facing_mode_;
}
const String& facingMode() const {
  DCHECK(hasFacingMode());
return member_facing_mode_;
}
String getFacingModeOr(const String& fallback_value) const;
String getFacingModeOr(String&& fallback_value) const;
void setFacingMode(const String& value);
void setFacingMode(String&& value);

bool hasFocusDistance() const {
  return has_focus_distance_;
}
double focusDistance() const {
  DCHECK(hasFocusDistance());
return member_focus_distance_;
}
double getFocusDistanceOr(double fallback_value) const {
  if (!hasFocusDistance()) {
  return fallback_value;
}
return member_focus_distance_;
}
void setFocusDistance(double value) {
  member_focus_distance_ = value;
has_focus_distance_ = true;
}

bool hasFocusMode() const {
  return has_focus_mode_;
}
const String& focusMode() const {
  DCHECK(hasFocusMode());
return member_focus_mode_;
}
String getFocusModeOr(const String& fallback_value) const;
String getFocusModeOr(String&& fallback_value) const;
void setFocusMode(const String& value);
void setFocusMode(String&& value);

bool hasFrameRate() const {
  return has_frame_rate_;
}
double frameRate() const {
  DCHECK(hasFrameRate());
return member_frame_rate_;
}
double getFrameRateOr(double fallback_value) const {
  if (!hasFrameRate()) {
  return fallback_value;
}
return member_frame_rate_;
}
void setFrameRate(double value) {
  member_frame_rate_ = value;
has_frame_rate_ = true;
}

bool hasGroupId() const {
  return has_group_id_;
}
const String& groupId() const {
  DCHECK(hasGroupId());
return member_group_id_;
}
String getGroupIdOr(const String& fallback_value) const;
String getGroupIdOr(String&& fallback_value) const;
void setGroupId(const String& value);
void setGroupId(String&& value);

bool hasHeight() const {
  return has_height_;
}
int32_t height() const {
  DCHECK(hasHeight());
return member_height_;
}
int32_t getHeightOr(int32_t fallback_value) const {
  if (!hasHeight()) {
  return fallback_value;
}
return member_height_;
}
void setHeight(int32_t value) {
  member_height_ = value;
has_height_ = true;
}

bool hasIso() const {
  return has_iso_;
}
double iso() const {
  DCHECK(hasIso());
return member_iso_;
}
double getIsoOr(double fallback_value) const {
  if (!hasIso()) {
  return fallback_value;
}
return member_iso_;
}
void setIso(double value) {
  member_iso_ = value;
has_iso_ = true;
}

bool hasLatency() const {
  return has_latency_;
}
double latency() const {
  DCHECK(hasLatency());
return member_latency_;
}
double getLatencyOr(double fallback_value) const {
  if (!hasLatency()) {
  return fallback_value;
}
return member_latency_;
}
void setLatency(double value) {
  member_latency_ = value;
has_latency_ = true;
}

bool hasLogicalSurface() const {
  return has_logical_surface_;
}
bool logicalSurface() const {
  DCHECK(hasLogicalSurface());
return member_logical_surface_;
}
bool getLogicalSurfaceOr(bool fallback_value) const {
  if (!hasLogicalSurface()) {
  return fallback_value;
}
return member_logical_surface_;
}
void setLogicalSurface(bool value) {
  member_logical_surface_ = value;
has_logical_surface_ = true;
}

bool hasNoiseSuppression() const {
  return has_noise_suppression_;
}
bool noiseSuppression() const {
  DCHECK(hasNoiseSuppression());
return member_noise_suppression_;
}
bool getNoiseSuppressionOr(bool fallback_value) const {
  if (!hasNoiseSuppression()) {
  return fallback_value;
}
return member_noise_suppression_;
}
void setNoiseSuppression(bool value) {
  member_noise_suppression_ = value;
has_noise_suppression_ = true;
}

bool hasPan() const {
  return has_pan_;
}
double pan() const {
  DCHECK(hasPan());
return member_pan_;
}
double getPanOr(double fallback_value) const {
  if (!hasPan()) {
  return fallback_value;
}
return member_pan_;
}
void setPan(double value) {
  member_pan_ = value;
has_pan_ = true;
}

bool hasPointsOfInterest() const {
  return has_points_of_interest_;
}
const HeapVector<Member<Point2D>>& pointsOfInterest() const {
  DCHECK(hasPointsOfInterest());
return member_points_of_interest_;
}
HeapVector<Member<Point2D>> getPointsOfInterestOr(const HeapVector<Member<Point2D>>& fallback_value) const;
HeapVector<Member<Point2D>> getPointsOfInterestOr(HeapVector<Member<Point2D>>&& fallback_value) const;
void setPointsOfInterest(const HeapVector<Member<Point2D>>& value);
void setPointsOfInterest(HeapVector<Member<Point2D>>&& value);

bool hasResizeMode() const {
  return has_resize_mode_;
}
const String& resizeMode() const {
  DCHECK(hasResizeMode());
return member_resize_mode_;
}
String getResizeModeOr(const String& fallback_value) const;
String getResizeModeOr(String&& fallback_value) const;
void setResizeMode(const String& value);
void setResizeMode(String&& value);

bool hasRestrictOwnAudio() const {
  return has_restrict_own_audio_;
}
bool restrictOwnAudio() const {
  DCHECK(hasRestrictOwnAudio());
return member_restrict_own_audio_;
}
bool getRestrictOwnAudioOr(bool fallback_value) const {
  if (!hasRestrictOwnAudio()) {
  return fallback_value;
}
return member_restrict_own_audio_;
}
void setRestrictOwnAudio(bool value) {
  member_restrict_own_audio_ = value;
has_restrict_own_audio_ = true;
}

bool hasSampleRate() const {
  return has_sample_rate_;
}
int32_t sampleRate() const {
  DCHECK(hasSampleRate());
return member_sample_rate_;
}
int32_t getSampleRateOr(int32_t fallback_value) const {
  if (!hasSampleRate()) {
  return fallback_value;
}
return member_sample_rate_;
}
void setSampleRate(int32_t value) {
  member_sample_rate_ = value;
has_sample_rate_ = true;
}

bool hasSampleSize() const {
  return has_sample_size_;
}
int32_t sampleSize() const {
  DCHECK(hasSampleSize());
return member_sample_size_;
}
int32_t getSampleSizeOr(int32_t fallback_value) const {
  if (!hasSampleSize()) {
  return fallback_value;
}
return member_sample_size_;
}
void setSampleSize(int32_t value) {
  member_sample_size_ = value;
has_sample_size_ = true;
}

bool hasSaturation() const {
  return has_saturation_;
}
double saturation() const {
  DCHECK(hasSaturation());
return member_saturation_;
}
double getSaturationOr(double fallback_value) const {
  if (!hasSaturation()) {
  return fallback_value;
}
return member_saturation_;
}
void setSaturation(double value) {
  member_saturation_ = value;
has_saturation_ = true;
}

bool hasScreenPixelRatio() const {
  return has_screen_pixel_ratio_;
}
double screenPixelRatio() const {
  DCHECK(hasScreenPixelRatio());
return member_screen_pixel_ratio_;
}
double getScreenPixelRatioOr(double fallback_value) const {
  if (!hasScreenPixelRatio()) {
  return fallback_value;
}
return member_screen_pixel_ratio_;
}
void setScreenPixelRatio(double value) {
  member_screen_pixel_ratio_ = value;
has_screen_pixel_ratio_ = true;
}

bool hasSharpness() const {
  return has_sharpness_;
}
double sharpness() const {
  DCHECK(hasSharpness());
return member_sharpness_;
}
double getSharpnessOr(double fallback_value) const {
  if (!hasSharpness()) {
  return fallback_value;
}
return member_sharpness_;
}
void setSharpness(double value) {
  member_sharpness_ = value;
has_sharpness_ = true;
}

bool hasSuppressLocalAudioPlayback() const {
  return has_suppress_local_audio_playback_;
}
bool suppressLocalAudioPlayback() const {
  DCHECK(hasSuppressLocalAudioPlayback());
return member_suppress_local_audio_playback_;
}
bool getSuppressLocalAudioPlaybackOr(bool fallback_value) const {
  if (!hasSuppressLocalAudioPlayback()) {
  return fallback_value;
}
return member_suppress_local_audio_playback_;
}
void setSuppressLocalAudioPlayback(bool value) {
  member_suppress_local_audio_playback_ = value;
has_suppress_local_audio_playback_ = true;
}

bool hasTilt() const {
  return has_tilt_;
}
double tilt() const {
  DCHECK(hasTilt());
return member_tilt_;
}
double getTiltOr(double fallback_value) const {
  if (!hasTilt()) {
  return fallback_value;
}
return member_tilt_;
}
void setTilt(double value) {
  member_tilt_ = value;
has_tilt_ = true;
}

bool hasTorch() const {
  return has_torch_;
}
bool torch() const {
  DCHECK(hasTorch());
return member_torch_;
}
bool getTorchOr(bool fallback_value) const {
  if (!hasTorch()) {
  return fallback_value;
}
return member_torch_;
}
void setTorch(bool value) {
  member_torch_ = value;
has_torch_ = true;
}

bool hasVoiceIsolation() const {
  return has_voice_isolation_;
}
bool voiceIsolation() const {
  DCHECK(hasVoiceIsolation());
return member_voice_isolation_;
}
bool getVoiceIsolationOr(bool fallback_value) const {
  if (!hasVoiceIsolation()) {
  return fallback_value;
}
return member_voice_isolation_;
}
void setVoiceIsolation(bool value) {
  member_voice_isolation_ = value;
has_voice_isolation_ = true;
}

bool hasWhiteBalanceMode() const {
  return has_white_balance_mode_;
}
const String& whiteBalanceMode() const {
  DCHECK(hasWhiteBalanceMode());
return member_white_balance_mode_;
}
String getWhiteBalanceModeOr(const String& fallback_value) const;
String getWhiteBalanceModeOr(String&& fallback_value) const;
void setWhiteBalanceMode(const String& value);
void setWhiteBalanceMode(String&& value);

bool hasWidth() const {
  return has_width_;
}
int32_t width() const {
  DCHECK(hasWidth());
return member_width_;
}
int32_t getWidthOr(int32_t fallback_value) const {
  if (!hasWidth()) {
  return fallback_value;
}
return member_width_;
}
void setWidth(int32_t value) {
  member_width_ = value;
has_width_ = true;
}

bool hasZoom() const {
  return has_zoom_;
}
double zoom() const {
  DCHECK(hasZoom());
return member_zoom_;
}
double getZoomOr(double fallback_value) const {
  if (!hasZoom()) {
  return fallback_value;
}
return member_zoom_;
}
void setZoom(double value) {
  member_zoom_ = value;
has_zoom_ = true;
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 43;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_aspect_ratio_ = false;
bool has_auto_gain_control_ = false;
bool has_background_blur_ = false;
bool has_background_segmentation_mask_ = false;
bool has_brightness_ = false;
bool has_channel_count_ = false;
bool has_color_temperature_ = false;
bool has_contrast_ = false;
bool has_cursor_ = false;
bool has_device_id_ = false;
bool has_display_surface_ = false;
bool has_echo_cancellation_ = false;
bool has_exposure_compensation_ = false;
bool has_exposure_mode_ = false;
bool has_exposure_time_ = false;
bool has_eye_gaze_correction_ = false;
bool has_face_framing_ = false;
bool has_facing_mode_ = false;
bool has_focus_distance_ = false;
bool has_focus_mode_ = false;
bool has_frame_rate_ = false;
bool has_group_id_ = false;
bool has_height_ = false;
bool has_iso_ = false;
bool has_latency_ = false;
bool has_logical_surface_ = false;
bool has_noise_suppression_ = false;
bool has_pan_ = false;
bool has_points_of_interest_ = false;
bool has_resize_mode_ = false;
bool has_restrict_own_audio_ = false;
bool has_sample_rate_ = false;
bool has_sample_size_ = false;
bool has_saturation_ = false;
bool has_screen_pixel_ratio_ = false;
bool has_sharpness_ = false;
bool has_suppress_local_audio_playback_ = false;
bool has_tilt_ = false;
bool has_torch_ = false;
bool has_voice_isolation_ = false;
bool has_white_balance_mode_ = false;
bool has_width_ = false;
bool has_zoom_ = false;

double member_aspect_ratio_;
bool member_auto_gain_control_;
bool member_background_blur_;
bool member_background_segmentation_mask_;
double member_brightness_;
int32_t member_channel_count_;
double member_color_temperature_;
double member_contrast_;
String member_cursor_;
String member_device_id_;
String member_display_surface_;
Member<V8UnionBooleanOrString> member_echo_cancellation_;
double member_exposure_compensation_;
String member_exposure_mode_;
double member_exposure_time_;
bool member_eye_gaze_correction_;
bool member_face_framing_;
String member_facing_mode_;
double member_focus_distance_;
String member_focus_mode_;
double member_frame_rate_;
String member_group_id_;
int32_t member_height_;
double member_iso_;
double member_latency_;
bool member_logical_surface_;
bool member_noise_suppression_;
double member_pan_;
HeapVector<Member<Point2D>> member_points_of_interest_;
String member_resize_mode_;
bool member_restrict_own_audio_;
int32_t member_sample_rate_;
int32_t member_sample_size_;
double member_saturation_;
double member_screen_pixel_ratio_;
double member_sharpness_;
bool member_suppress_local_audio_playback_;
double member_tilt_;
bool member_torch_;
bool member_voice_isolation_;
String member_white_balance_mode_;
int32_t member_width_;
double member_zoom_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_MEDIA_TRACK_SETTINGS_H_
