// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_MEDIA_STREAM_TRACK_PROCESSOR_INIT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_MEDIA_STREAM_TRACK_PROCESSOR_INIT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class MediaStreamTrack;

class MODULES_EXPORT MediaStreamTrackProcessorInit : public bindings::InputDictionaryBase {
  
  public:
static MediaStreamTrackProcessorInit* Create() {
  return MakeGarbageCollected<MediaStreamTrackProcessorInit>();
}
static MediaStreamTrackProcessorInit* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<MediaStreamTrackProcessorInit>(isolate);
}
static MediaStreamTrackProcessorInit* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  MediaStreamTrackProcessorInit();
explicit  MediaStreamTrackProcessorInit(v8::Isolate* isolate);

bool hasMaxBufferSize() const {
  return has_max_buffer_size_;
}
uint16_t maxBufferSize() const {
  DCHECK(hasMaxBufferSize());
return member_max_buffer_size_;
}
uint16_t getMaxBufferSizeOr(uint16_t fallback_value) const {
  if (!hasMaxBufferSize()) {
  return fallback_value;
}
return member_max_buffer_size_;
}
void setMaxBufferSize(uint16_t value) {
  member_max_buffer_size_ = value;
has_max_buffer_size_ = true;
}

bool hasTrack() const {
  return true;
}
MediaStreamTrack* track() const {
  return member_track_.Get();
}
void setTrack(MediaStreamTrack* value) {
  member_track_ = value;
DCHECK(member_track_);
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_max_buffer_size_ = false;

uint16_t member_max_buffer_size_;
Member<MediaStreamTrack> member_track_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_MEDIA_STREAM_TRACK_PROCESSOR_INIT_H_
