// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_MEDIA_SESSION_SEEK_TO_ACTION_DETAILS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_MEDIA_SESSION_SEEK_TO_ACTION_DETAILS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_media_session_action_details.h"
#include "third_party/blink/renderer/modules/modules_export.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT MediaSessionSeekToActionDetails : public MediaSessionActionDetails {
  
  public:
static MediaSessionSeekToActionDetails* Create() {
  return MakeGarbageCollected<MediaSessionSeekToActionDetails>();
}
static MediaSessionSeekToActionDetails* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<MediaSessionSeekToActionDetails>(isolate);
}
static MediaSessionSeekToActionDetails* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  MediaSessionSeekToActionDetails();
explicit  MediaSessionSeekToActionDetails(v8::Isolate* isolate);

bool hasFastSeek() const {
  return has_fast_seek_;
}
bool fastSeek() const {
  DCHECK(hasFastSeek());
return member_fast_seek_;
}
bool getFastSeekOr(bool fallback_value) const {
  if (!hasFastSeek()) {
  return fallback_value;
}
return member_fast_seek_;
}
void setFastSeek(bool value) {
  member_fast_seek_ = value;
has_fast_seek_ = true;
}

bool hasSeekTime() const {
  return true;
}
double seekTime() const {
  return member_seek_time_;
}
void setSeekTime(double value) {
  member_seek_time_ = value;
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = MediaSessionActionDetails::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_fast_seek_ = false;

bool member_fast_seek_;
double member_seek_time_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_MEDIA_SESSION_SEEK_TO_ACTION_DETAILS_H_
