// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_MEDIA_POSITION_STATE_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_MEDIA_POSITION_STATE_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT MediaPositionState : public bindings::InputDictionaryBase {
  
  public:
static MediaPositionState* Create() {
  return MakeGarbageCollected<MediaPositionState>();
}
static MediaPositionState* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<MediaPositionState>(isolate);
}
static MediaPositionState* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  MediaPositionState();
explicit  MediaPositionState(v8::Isolate* isolate);

bool hasDuration() const {
  return has_duration_;
}
double duration() const {
  DCHECK(hasDuration());
return member_duration_;
}
double getDurationOr(double fallback_value) const {
  if (!hasDuration()) {
  return fallback_value;
}
return member_duration_;
}
void setDuration(double value) {
  member_duration_ = value;
has_duration_ = true;
}

bool hasPlaybackRate() const {
  return has_playback_rate_;
}
double playbackRate() const {
  DCHECK(hasPlaybackRate());
return member_playback_rate_;
}
double getPlaybackRateOr(double fallback_value) const {
  if (!hasPlaybackRate()) {
  return fallback_value;
}
return member_playback_rate_;
}
void setPlaybackRate(double value) {
  member_playback_rate_ = value;
has_playback_rate_ = true;
}

bool hasPosition() const {
  return has_position_;
}
double position() const {
  DCHECK(hasPosition());
return member_position_;
}
double getPositionOr(double fallback_value) const {
  if (!hasPosition()) {
  return fallback_value;
}
return member_position_;
}
void setPosition(double value) {
  member_position_ = value;
has_position_ = true;
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 3;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_duration_ = false;
bool has_playback_rate_ = false;
bool has_position_ = false;

double member_duration_;
double member_playback_rate_;
double member_position_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_MEDIA_POSITION_STATE_H_
