// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_MEDIA_KEY_SYSTEM_CONFIGURATION_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_MEDIA_KEY_SYSTEM_CONFIGURATION_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_media_keys_requirement.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;
class MediaKeySystemMediaCapability;

class MODULES_EXPORT MediaKeySystemConfiguration : public bindings::DictionaryBase {
  
  public:
static MediaKeySystemConfiguration* Create() {
  return MakeGarbageCollected<MediaKeySystemConfiguration>();
}
static MediaKeySystemConfiguration* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<MediaKeySystemConfiguration>(isolate);
}
static MediaKeySystemConfiguration* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  MediaKeySystemConfiguration();
explicit  MediaKeySystemConfiguration(v8::Isolate* isolate);

bool hasAudioCapabilities() const {
  return true;
}
const HeapVector<Member<MediaKeySystemMediaCapability>>& audioCapabilities() const {
  return member_audio_capabilities_;
}
void setAudioCapabilities(const HeapVector<Member<MediaKeySystemMediaCapability>>& value);
void setAudioCapabilities(HeapVector<Member<MediaKeySystemMediaCapability>>&& value);

bool hasDistinctiveIdentifier() const {
  return true;
}
V8MediaKeysRequirement distinctiveIdentifier() const {
  return member_distinctive_identifier_;
}
void setDistinctiveIdentifier(V8MediaKeysRequirement value) {
  member_distinctive_identifier_ = value;
}
void setDistinctiveIdentifier(V8MediaKeysRequirement::Enum value) {
  member_distinctive_identifier_ = V8MediaKeysRequirement(value);
}

bool hasInitDataTypes() const {
  return true;
}
const Vector<String>& initDataTypes() const {
  return member_init_data_types_;
}
void setInitDataTypes(const Vector<String>& value);
void setInitDataTypes(Vector<String>&& value);

bool hasLabel() const {
  return true;
}
const String& label() const {
  return member_label_;
}
void setLabel(const String& value);
void setLabel(String&& value);

bool hasPersistentState() const {
  return true;
}
V8MediaKeysRequirement persistentState() const {
  return member_persistent_state_;
}
void setPersistentState(V8MediaKeysRequirement value) {
  member_persistent_state_ = value;
}
void setPersistentState(V8MediaKeysRequirement::Enum value) {
  member_persistent_state_ = V8MediaKeysRequirement(value);
}

bool hasSessionTypes() const {
  return has_session_types_;
}
const Vector<String>& sessionTypes() const {
  DCHECK(hasSessionTypes());
return member_session_types_;
}
Vector<String> getSessionTypesOr(const Vector<String>& fallback_value) const;
Vector<String> getSessionTypesOr(Vector<String>&& fallback_value) const;
void setSessionTypes(const Vector<String>& value);
void setSessionTypes(Vector<String>&& value);

bool hasVideoCapabilities() const {
  return true;
}
const HeapVector<Member<MediaKeySystemMediaCapability>>& videoCapabilities() const {
  return member_video_capabilities_;
}
void setVideoCapabilities(const HeapVector<Member<MediaKeySystemMediaCapability>>& value);
void setVideoCapabilities(HeapVector<Member<MediaKeySystemMediaCapability>>&& value);




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 7;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_session_types_ = false;

HeapVector<Member<MediaKeySystemMediaCapability>> member_audio_capabilities_;
V8MediaKeysRequirement member_distinctive_identifier_{V8MediaKeysRequirement::Enum::kOptional};
Vector<String> member_init_data_types_;
String member_label_{""};
V8MediaKeysRequirement member_persistent_state_{V8MediaKeysRequirement::Enum::kOptional};
Vector<String> member_session_types_;
HeapVector<Member<MediaKeySystemMediaCapability>> member_video_capabilities_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_MEDIA_KEY_SYSTEM_CONFIGURATION_H_
