// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_MEDIA_KEY_MESSAGE_EVENT_INIT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_MEDIA_KEY_MESSAGE_EVENT_INIT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_event_init.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_media_key_message_type.h"
#include "third_party/blink/renderer/core/typed_arrays/array_buffer_view_helpers.h"
#include "third_party/blink/renderer/core/typed_arrays/dom_typed_array.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT MediaKeyMessageEventInit : public EventInit {
  
  public:
static MediaKeyMessageEventInit* Create() {
  return MakeGarbageCollected<MediaKeyMessageEventInit>();
}
static MediaKeyMessageEventInit* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<MediaKeyMessageEventInit>(isolate);
}
static MediaKeyMessageEventInit* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  MediaKeyMessageEventInit();
explicit  MediaKeyMessageEventInit(v8::Isolate* isolate);

bool hasMessage() const {
  return true;
}
DOMArrayBuffer* message() const {
  return member_message_.Get();
}
void setMessage(DOMArrayBuffer* value) {
  member_message_ = value;
DCHECK(member_message_);
}

bool hasMessageType() const {
  return true;
}
V8MediaKeyMessageType messageType() const {
  return member_message_type_;
}
void setMessageType(V8MediaKeyMessageType value) {
  member_message_type_ = value;
}
void setMessageType(V8MediaKeyMessageType::Enum value) {
  member_message_type_ = V8MediaKeyMessageType(value);
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = EventInit::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



Member<DOMArrayBuffer> member_message_;
V8MediaKeyMessageType member_message_type_{static_cast<V8MediaKeyMessageType::Enum>(0)};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_MEDIA_KEY_MESSAGE_EVENT_INIT_H_
