// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_MEDIA_CONFIGURATION_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_MEDIA_CONFIGURATION_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class AudioConfiguration;
class ExceptionState;
class VideoConfiguration;

class MODULES_EXPORT MediaConfiguration : public bindings::InputDictionaryBase {
  
  public:
static MediaConfiguration* Create() {
  return MakeGarbageCollected<MediaConfiguration>();
}
static MediaConfiguration* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<MediaConfiguration>(isolate);
}
static MediaConfiguration* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  MediaConfiguration();
explicit  MediaConfiguration(v8::Isolate* isolate);

bool hasAudio() const {
  return has_audio_;
}
AudioConfiguration* audio() const {
  DCHECK(hasAudio());
return member_audio_.Get();
}
AudioConfiguration* getAudioOr(AudioConfiguration* fallback_value) const {
  if (!hasAudio()) {
  return fallback_value;
}
return member_audio_.Get();
}
void setAudio(AudioConfiguration* value) {
  member_audio_ = value;
has_audio_ = true;
DCHECK(member_audio_);
}

bool hasVideo() const {
  return has_video_;
}
VideoConfiguration* video() const {
  DCHECK(hasVideo());
return member_video_.Get();
}
VideoConfiguration* getVideoOr(VideoConfiguration* fallback_value) const {
  if (!hasVideo()) {
  return fallback_value;
}
return member_video_.Get();
}
void setVideo(VideoConfiguration* value) {
  member_video_ = value;
has_video_ = true;
DCHECK(member_video_);
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_audio_ = false;
bool has_video_ = false;

Member<AudioConfiguration> member_audio_;
Member<VideoConfiguration> member_video_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_MEDIA_CONFIGURATION_H_
