// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_LANGUAGE_MODEL_EXPECTED_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_LANGUAGE_MODEL_EXPECTED_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_language_model_message_type.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT LanguageModelExpected : public bindings::InputDictionaryBase {
  
  public:
static LanguageModelExpected* Create() {
  return MakeGarbageCollected<LanguageModelExpected>();
}
static LanguageModelExpected* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<LanguageModelExpected>(isolate);
}
static LanguageModelExpected* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  LanguageModelExpected();
explicit  LanguageModelExpected(v8::Isolate* isolate);

bool hasLanguages() const {
  return has_languages_;
}
const Vector<String>& languages() const {
  DCHECK(hasLanguages());
return member_languages_;
}
Vector<String> getLanguagesOr(const Vector<String>& fallback_value) const;
Vector<String> getLanguagesOr(Vector<String>&& fallback_value) const;
void setLanguages(const Vector<String>& value);
void setLanguages(Vector<String>&& value);

bool hasType() const {
  return true;
}
V8LanguageModelMessageType type() const {
  return member_type_;
}
void setType(V8LanguageModelMessageType value) {
  member_type_ = value;
}
void setType(V8LanguageModelMessageType::Enum value) {
  member_type_ = V8LanguageModelMessageType(value);
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_languages_ = false;

Vector<String> member_languages_;
V8LanguageModelMessageType member_type_{static_cast<V8LanguageModelMessageType::Enum>(0)};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_LANGUAGE_MODEL_EXPECTED_H_
