// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_LANDMARK_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_LANDMARK_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_landmark_type.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class Point2D;

class MODULES_EXPORT Landmark : public bindings::DictionaryBase {
  
  public:
static Landmark* Create() {
  return MakeGarbageCollected<Landmark>();
}
static Landmark* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<Landmark>(isolate);
}
static Landmark* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  Landmark();
explicit  Landmark(v8::Isolate* isolate);

bool hasLocations() const {
  return true;
}
const HeapVector<Member<Point2D>>& locations() const {
  return member_locations_;
}
void setLocations(const HeapVector<Member<Point2D>>& value);
void setLocations(HeapVector<Member<Point2D>>&& value);

bool hasType() const {
  return has_type_;
}
V8LandmarkType type() const {
  DCHECK(hasType());
return member_type_;
}
V8LandmarkType getTypeOr(V8LandmarkType fallback_value) const {
  if (!hasType()) {
  return fallback_value;
}
return member_type_;
}
void setType(V8LandmarkType value) {
  member_type_ = value;
has_type_ = true;
}
void setType(V8LandmarkType::Enum value) {
  member_type_ = V8LandmarkType(value);
has_type_ = true;
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_type_ = false;

HeapVector<Member<Point2D>> member_locations_;
V8LandmarkType member_type_{static_cast<V8LandmarkType::Enum>(0)};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_LANDMARK_H_
