// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_image_object.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"sizes",
"src",
"type",
};


}  // namespace 

ImageObject* ImageObject::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  ImageObject* dictionary = MakeGarbageCollected<ImageObject>(isolate);
if (!v8_value->IsObject()) {
  const char* const class_like_name = "ImageObject";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 ImageObject::ImageObject() {
  
}

 ImageObject::ImageObject(v8::Isolate* isolate) {
  
}



String ImageObject::getSizesOr(const String& fallback_value) const {
  if (!hasSizes()) {
  return fallback_value;
}
return member_sizes_;
}

String ImageObject::getSizesOr(String&& fallback_value) const {
  if (!hasSizes()) {
  return std::move(fallback_value);
}
return member_sizes_;
}

void ImageObject::setSizes(const String& value) {
  member_sizes_ = value;
has_sizes_ = true;
}

void ImageObject::setSizes(String&& value) {
  member_sizes_ = std::move(value);
has_sizes_ = true;
}




void ImageObject::setSrc(const String& value) {
  member_src_ = value;
}

void ImageObject::setSrc(String&& value) {
  member_src_ = std::move(value);
}




String ImageObject::getTypeOr(const String& fallback_value) const {
  if (!hasType()) {
  return fallback_value;
}
return member_type_;
}

String ImageObject::getTypeOr(String&& fallback_value) const {
  if (!hasType()) {
  return std::move(fallback_value);
}
return member_type_;
}

void ImageObject::setType(const String& value) {
  member_type_ = value;
has_type_ = true;
}

void ImageObject::setType(String&& value) {
  member_type_ = std::move(value);
has_type_ = true;
}




void ImageObject::Trace(Visitor* visitor) const {
  bindings::DictionaryBase::Trace(visitor);
}

void ImageObject::FillTemplateProperties(Vector<std::string_view>& properties) const {
  static_assert(std::size(kOwnPropertyNames) == kOwnPropertyCount);
properties.AppendRange(std::cbegin(kOwnPropertyNames), std::cend(kOwnPropertyNames));
DCHECK_EQ(properties.size(), kTotalPropertyCount);
}

void ImageObject::FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const {
  CHECK_EQ(kOwnPropertyCount, values.size());
if (hasSizes()) {
  values[0] = ToV8Traits<IDLString>::ToV8(script_state, member_sizes_);
DCHECK(!values[0].IsEmpty());
}
if (hasSrc()) {
  values[1] = ToV8Traits<IDLUSVString>::ToV8(script_state, member_src_);
DCHECK(!values[1].IsEmpty());
}
if (hasType()) {
  values[2] = ToV8Traits<IDLString>::ToV8(script_state, member_type_);
DCHECK(!values[2].IsEmpty());
}
}

const void* ImageObject::TemplateKey() const {
  static const void *s_key = &s_key;
return s_key;
}

v8::Local<v8::Object> ImageObject::FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const {
  v8::MaybeLocal<v8::Value> values[kTotalPropertyCount];
FillValuesImpl(script_state, values);
return dict_template->NewInstance(script_state->GetContext(), values);
}

void ImageObject::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "ImageObject";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("sizes");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_sizes_, member_sizes_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("src");
constexpr bool is_required = true;
bool fallback_presence_var;
if (!bindings::GetDictionaryMemberFromV8Object<IDLUSVString, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), fallback_presence_var, member_src_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("type");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), has_type_, member_type_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> ImageObject::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
