// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_IMAGE_DECODE_RESULT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_IMAGE_DECODE_RESULT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class VideoFrame;

class MODULES_EXPORT ImageDecodeResult : public bindings::DictionaryBase {
  
  public:
static ImageDecodeResult* Create() {
  return MakeGarbageCollected<ImageDecodeResult>();
}
static ImageDecodeResult* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<ImageDecodeResult>(isolate);
}
static ImageDecodeResult* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  ImageDecodeResult();
explicit  ImageDecodeResult(v8::Isolate* isolate);

bool hasComplete() const {
  return true;
}
bool complete() const {
  return member_complete_;
}
void setComplete(bool value) {
  member_complete_ = value;
}

bool hasImage() const {
  return true;
}
VideoFrame* image() const {
  return member_image_.Get();
}
void setImage(VideoFrame* value) {
  member_image_ = value;
DCHECK(member_image_);
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



bool member_complete_;
Member<VideoFrame> member_image_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_IMAGE_DECODE_RESULT_H_
