// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_IDENTITY_RESOLVE_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_IDENTITY_RESOLVE_OPTIONS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT IdentityResolveOptions : public bindings::InputDictionaryBase {
  
  public:
static IdentityResolveOptions* Create() {
  return MakeGarbageCollected<IdentityResolveOptions>();
}
static IdentityResolveOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<IdentityResolveOptions>(isolate);
}
static IdentityResolveOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  IdentityResolveOptions();
explicit  IdentityResolveOptions(v8::Isolate* isolate);

bool hasAccountId() const {
  return has_account_id_;
}
const String& accountId() const {
  DCHECK(hasAccountId());
return member_account_id_;
}
String getAccountIdOr(const String& fallback_value) const;
String getAccountIdOr(String&& fallback_value) const;
void setAccountId(const String& value);
void setAccountId(String&& value);




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 1;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_account_id_ = false;

String member_account_id_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_IDENTITY_RESOLVE_OPTIONS_H_
