// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_IDENTITY_PROVIDER_REQUEST_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_IDENTITY_PROVIDER_REQUEST_OPTIONS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/script_value.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_identity_provider_config.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_identity_provider_request_options_format.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;
class IdentityProviderField;
class V8UnionIdentityProviderFieldOrUSVString;

class MODULES_EXPORT IdentityProviderRequestOptions : public IdentityProviderConfig {
  
  public:
static IdentityProviderRequestOptions* Create() {
  return MakeGarbageCollected<IdentityProviderRequestOptions>();
}
static IdentityProviderRequestOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<IdentityProviderRequestOptions>(isolate);
}
static IdentityProviderRequestOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  IdentityProviderRequestOptions();
explicit  IdentityProviderRequestOptions(v8::Isolate* isolate);

bool hasDomainHint() const {
  return has_domain_hint_;
}
const String& domainHint() const {
  DCHECK(hasDomainHint());
return member_domain_hint_;
}
String getDomainHintOr(const String& fallback_value) const;
String getDomainHintOr(String&& fallback_value) const;
void setDomainHint(const String& value);
void setDomainHint(String&& value);

bool hasFields() const {
  return has_fields_;
}
const HeapVector<Member<V8UnionIdentityProviderFieldOrUSVString>>& fields() const {
  DCHECK(hasFields());
return member_fields_;
}
HeapVector<Member<V8UnionIdentityProviderFieldOrUSVString>> getFieldsOr(const HeapVector<Member<V8UnionIdentityProviderFieldOrUSVString>>& fallback_value) const;
HeapVector<Member<V8UnionIdentityProviderFieldOrUSVString>> getFieldsOr(HeapVector<Member<V8UnionIdentityProviderFieldOrUSVString>>&& fallback_value) const;
void setFields(const HeapVector<Member<V8UnionIdentityProviderFieldOrUSVString>>& value);
void setFields(HeapVector<Member<V8UnionIdentityProviderFieldOrUSVString>>&& value);

bool hasFormat() const {
  return has_format_;
}
V8IdentityProviderRequestOptionsFormat format() const {
  DCHECK(hasFormat());
return member_format_;
}
V8IdentityProviderRequestOptionsFormat getFormatOr(V8IdentityProviderRequestOptionsFormat fallback_value) const {
  if (!hasFormat()) {
  return fallback_value;
}
return member_format_;
}
void setFormat(V8IdentityProviderRequestOptionsFormat value) {
  member_format_ = value;
has_format_ = true;
}
void setFormat(V8IdentityProviderRequestOptionsFormat::Enum value) {
  member_format_ = V8IdentityProviderRequestOptionsFormat(value);
has_format_ = true;
}

bool hasLoginHint() const {
  return has_login_hint_;
}
const String& loginHint() const {
  DCHECK(hasLoginHint());
return member_login_hint_;
}
String getLoginHintOr(const String& fallback_value) const;
String getLoginHintOr(String&& fallback_value) const;
void setLoginHint(const String& value);
void setLoginHint(String&& value);

bool hasNonce() const {
  return has_nonce_;
}
const String& nonce() const {
  DCHECK(hasNonce());
return member_nonce_;
}
String getNonceOr(const String& fallback_value) const;
String getNonceOr(String&& fallback_value) const;
void setNonce(const String& value);
void setNonce(String&& value);

bool hasParams() const {
  return !member_params_.IsEmpty();
}
const ScriptValue& params() const {
  DCHECK(hasParams());
return member_params_;
}
ScriptValue getParamsOr(const ScriptValue& fallback_value) const {
  if (!hasParams()) {
  return fallback_value;
}
return member_params_;
}
void setParams(const ScriptValue& value) {
  member_params_ = value;
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = IdentityProviderConfig::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 6;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_domain_hint_ = false;
bool has_fields_ = false;
bool has_format_ = false;
bool has_login_hint_ = false;
bool has_nonce_ = false;

String member_domain_hint_;
HeapVector<Member<V8UnionIdentityProviderFieldOrUSVString>> member_fields_;
V8IdentityProviderRequestOptionsFormat member_format_{static_cast<V8IdentityProviderRequestOptionsFormat::Enum>(0)};
String member_login_hint_;
String member_nonce_;
ScriptValue member_params_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_IDENTITY_PROVIDER_REQUEST_OPTIONS_H_
