// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_IDENTITY_PROVIDER_CONFIG_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_IDENTITY_PROVIDER_CONFIG_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT IdentityProviderConfig : public bindings::InputDictionaryBase {
  
  public:
static IdentityProviderConfig* Create() {
  return MakeGarbageCollected<IdentityProviderConfig>();
}
static IdentityProviderConfig* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<IdentityProviderConfig>(isolate);
}
static IdentityProviderConfig* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  IdentityProviderConfig();
explicit  IdentityProviderConfig(v8::Isolate* isolate);

bool hasClientId() const {
  return has_client_id_;
}
const String& clientId() const {
  DCHECK(hasClientId());
return member_client_id_;
}
String getClientIdOr(const String& fallback_value) const;
String getClientIdOr(String&& fallback_value) const;
void setClientId(const String& value);
void setClientId(String&& value);

bool hasConfigURL() const {
  return true;
}
const String& configURL() const {
  return member_config_url_;
}
void setConfigURL(const String& value);
void setConfigURL(String&& value);

bool hasType() const {
  return has_type_;
}
const String& type() const {
  DCHECK(hasType());
return member_type_;
}
String getTypeOr(const String& fallback_value) const;
String getTypeOr(String&& fallback_value) const;
void setType(const String& value);
void setType(String&& value);




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 3;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_client_id_ = false;
bool has_type_ = false;

String member_client_id_;
String member_config_url_;
String member_type_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_IDENTITY_PROVIDER_CONFIG_H_
