// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_identity_credential_request_options.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_identity_provider_request_options.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"context",
"mediation",
"mode",
"providers",
};


}  // namespace 

IdentityCredentialRequestOptions* IdentityCredentialRequestOptions::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  IdentityCredentialRequestOptions* dictionary = MakeGarbageCollected<IdentityCredentialRequestOptions>(isolate);
if (!v8_value->IsObject()) {
  const char* const class_like_name = "IdentityCredentialRequestOptions";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 IdentityCredentialRequestOptions::IdentityCredentialRequestOptions() {
  
}

 IdentityCredentialRequestOptions::IdentityCredentialRequestOptions(v8::Isolate* isolate) {
  
}








String IdentityCredentialRequestOptions::getMediationOr(const String& fallback_value) const {
  if (!hasMediation()) {
  return fallback_value;
}
return member_mediation_;
}

String IdentityCredentialRequestOptions::getMediationOr(String&& fallback_value) const {
  if (!hasMediation()) {
  return std::move(fallback_value);
}
return member_mediation_;
}

void IdentityCredentialRequestOptions::setMediation(const String& value) {
  member_mediation_ = value;
has_mediation_ = true;
}

void IdentityCredentialRequestOptions::setMediation(String&& value) {
  member_mediation_ = std::move(value);
has_mediation_ = true;
}









void IdentityCredentialRequestOptions::setProviders(const HeapVector<Member<IdentityProviderRequestOptions>>& value) {
  member_providers_ = value;
}

void IdentityCredentialRequestOptions::setProviders(HeapVector<Member<IdentityProviderRequestOptions>>&& value) {
  member_providers_ = std::move(value);
}




void IdentityCredentialRequestOptions::Trace(Visitor* visitor) const {
  visitor->Trace(member_providers_);
bindings::InputDictionaryBase::Trace(visitor);
}

void IdentityCredentialRequestOptions::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "IdentityCredentialRequestOptions";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("context");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
bool fallback_presence_var;
if (!bindings::GetDictionaryMemberFromV8Object<V8IdentityCredentialRequestOptionsContext, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), fallback_presence_var, member_context_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("mediation");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUSVString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_mediation_, member_mediation_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("mode");
if (!bindings::GetDictionaryMemberFromV8Object<V8IdentityCredentialRequestOptionsMode, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), fallback_presence_var, member_mode_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("providers");
constexpr bool is_required = true;
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<IdentityProviderRequestOptions>, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), fallback_presence_var, member_providers_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> IdentityCredentialRequestOptions::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
