// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_html_iframe_element.h"

#include "third_party/blink/public/mojom/origin_trials/origin_trial_feature.mojom-shared.h"
#include "third_party/blink/renderer/bindings/core/v8/binding_security.h"
#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/is_return_type_compatible.h"
#include "third_party/blink/renderer/bindings/core/v8/local_window_proxy.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_document.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_dom_token_list.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_feature_policy.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_html_constructor.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_set_return_value_for_core.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_trusted_html.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_union_string_trustedhtml.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_window.h"
#include "third_party/blink/renderer/core/dom/document.h"
#include "third_party/blink/renderer/core/dom/dom_token_list.h"
#include "third_party/blink/renderer/core/execution_context/execution_context.h"
#include "third_party/blink/renderer/core/frame/dom_window.h"
#include "third_party/blink/renderer/core/frame/local_frame.h"
#include "third_party/blink/renderer/core/frame/web_feature.h"
#include "third_party/blink/renderer/core/html/custom/ce_reactions_scope.h"
#include "third_party/blink/renderer/core/html/html_iframe_element.h"
#include "third_party/blink/renderer/core/html_names.h"
#include "third_party/blink/renderer/core/keywords.h"
#include "third_party/blink/renderer/core/permissions_policy/dom_feature_policy.h"
#include "third_party/blink/renderer/core/trustedtypes/trusted_html.h"
#include "third_party/blink/renderer/modules/payments/html_iframe_element_payments.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/idl_member_installer.h"
#include "third_party/blink/renderer/platform/bindings/runtime_call_stats.h"
#include "third_party/blink/renderer/platform/bindings/v8_binding.h"
#include "third_party/blink/renderer/platform/bindings/v8_object_constructor.h"
#include "third_party/blink/renderer/platform/instrumentation/use_counter.h"

namespace blink {



void V8HTMLIFrameElement::Impl::Init() {
  V8HTMLIFrameElement::install_interface_template_func_ = InstallInterfaceTemplate;
V8HTMLIFrameElement::install_unconditional_props_func_ = InstallUnconditionalProperties;
V8HTMLIFrameElement::install_context_independent_props_func_ = InstallContextIndependentProperties;
V8HTMLIFrameElement::install_context_dependent_props_func_ = InstallContextDependentProperties;
}

namespace  {

namespace v8_html_iframe_element {


void SrcAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLIFrameElement_src_Getter");
BLINK_BINDINGS_TRACE_EVENT("HTMLIFrameElement.src.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
HTMLIFrameElement* blink_receiver = V8HTMLIFrameElement::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->GetURLAttribute(html_names::kSrcAttr);
static_assert(bindings::IsReturnTypeCompatible<IDLUSVString, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNonNullable);
}

void SrcAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLIFrameElement_src_Setter");
BLINK_BINDINGS_TRACE_EVENT("HTMLIFrameElement.src.set");

v8::Isolate* isolate = info.GetIsolate();
ExceptionState exception_state(isolate);

// [CEReactions]
CEReactionsScope ce_reactions_scope(isolate);

v8::Local<v8::Object> v8_receiver = info.This();
HTMLIFrameElement* blink_receiver = V8HTMLIFrameElement::ToWrappableUnsafe(isolate, v8_receiver);
v8::Local<v8::Value> v8_property_value = info[0];
auto&& arg1_value = NativeValueTraits<IDLUSVString>::NativeValue(isolate, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setAttribute(html_names::kSrcAttr, arg1_value);

}


void SrcdocAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLIFrameElement_srcdoc_Getter");
BLINK_BINDINGS_TRACE_EVENT("HTMLIFrameElement.srcdoc.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
HTMLIFrameElement* blink_receiver = V8HTMLIFrameElement::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->srcdoc();
static_assert(bindings::IsReturnTypeCompatible<V8UnionStringOrTrustedHTML, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
v8::Local<v8::Value> v8_return_value = ToV8Traits<V8UnionStringOrTrustedHTML>::ToV8(script_state, return_value);
bindings::V8SetReturnValue(info, v8_return_value);
}

void SrcdocAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLIFrameElement_srcdoc_Setter");
BLINK_BINDINGS_TRACE_EVENT("HTMLIFrameElement.srcdoc.set");

v8::Isolate* isolate = info.GetIsolate();
ExceptionState exception_state(isolate);

// [CEReactions]
CEReactionsScope ce_reactions_scope(isolate);

v8::Local<v8::Object> v8_receiver = info.This();
HTMLIFrameElement* blink_receiver = V8HTMLIFrameElement::ToWrappableUnsafe(isolate, v8_receiver);
v8::Local<v8::Value> v8_property_value = info[0];
auto&& arg1_value = NativeValueTraits<V8UnionStringOrTrustedHTML>::NativeValue(isolate, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setSrcdoc(arg1_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}


void NameAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLIFrameElement_name_Getter");
BLINK_BINDINGS_TRACE_EVENT("HTMLIFrameElement.name.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
HTMLIFrameElement* blink_receiver = V8HTMLIFrameElement::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->GetNameAttribute();
static_assert(bindings::IsReturnTypeCompatible<IDLString, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNonNullable);
}

void NameAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLIFrameElement_name_Setter");
BLINK_BINDINGS_TRACE_EVENT("HTMLIFrameElement.name.set");

bindings::PerformAttributeSetCEReactionsReflectTypeString(info, html_names::kNameAttr);
}


void SandboxAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLIFrameElement_sandbox_Getter");
BLINK_BINDINGS_TRACE_EVENT("HTMLIFrameElement.sandbox.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
HTMLIFrameElement* blink_receiver = V8HTMLIFrameElement::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->sandbox();
static_assert(bindings::IsReturnTypeCompatible<DOMTokenList, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}

void SandboxAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLIFrameElement_sandbox_Setter");
BLINK_BINDINGS_TRACE_EVENT("HTMLIFrameElement.sandbox.set");

// [PutForwards]
v8::Local<v8::Value> target;
v8::Local<v8::Object> v8_receiver = info.This();
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const char* const property_name = "sandbox";
if (!v8_receiver->Get(current_context, V8AtomicString(isolate, property_name)).ToLocal(&target)) {
  return;
}
if (!target->IsObject()) {
  V8ThrowException::ThrowTypeError(isolate, "The attribute value is not an object");
return;
}
bool did_set;
v8::Local<v8::Value> v8_property_value = info[0];
if (!target.As<v8::Object>()->Set(current_context, V8AtomicString(isolate, "value"), v8_property_value).To(&did_set)) {
  return;
}
return;
}


void AllowFullscreenAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLIFrameElement_allowFullscreen_Getter");
BLINK_BINDINGS_TRACE_EVENT("HTMLIFrameElement.allowFullscreen.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
HTMLIFrameElement* blink_receiver = V8HTMLIFrameElement::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->FastHasAttribute(html_names::kAllowfullscreenAttr);
static_assert(bindings::IsReturnTypeCompatible<IDLBoolean, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<bool>());
}

void AllowFullscreenAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLIFrameElement_allowFullscreen_Setter");
BLINK_BINDINGS_TRACE_EVENT("HTMLIFrameElement.allowFullscreen.set");

bindings::PerformAttributeSetCEReactionsReflectTypeBoolean(info, html_names::kAllowfullscreenAttr);
}


void WidthAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLIFrameElement_width_Getter");
BLINK_BINDINGS_TRACE_EVENT("HTMLIFrameElement.width.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
HTMLIFrameElement* blink_receiver = V8HTMLIFrameElement::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->FastGetAttribute(html_names::kWidthAttr);
static_assert(bindings::IsReturnTypeCompatible<IDLString, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNonNullable);
}

void WidthAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLIFrameElement_width_Setter");
BLINK_BINDINGS_TRACE_EVENT("HTMLIFrameElement.width.set");

bindings::PerformAttributeSetCEReactionsReflectTypeString(info, html_names::kWidthAttr);
}


void HeightAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLIFrameElement_height_Getter");
BLINK_BINDINGS_TRACE_EVENT("HTMLIFrameElement.height.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
HTMLIFrameElement* blink_receiver = V8HTMLIFrameElement::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->FastGetAttribute(html_names::kHeightAttr);
static_assert(bindings::IsReturnTypeCompatible<IDLString, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNonNullable);
}

void HeightAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLIFrameElement_height_Setter");
BLINK_BINDINGS_TRACE_EVENT("HTMLIFrameElement.height.set");

bindings::PerformAttributeSetCEReactionsReflectTypeString(info, html_names::kHeightAttr);
}


void ContentDocumentAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLIFrameElement_contentDocument_Getter");
BLINK_BINDINGS_TRACE_EVENT("HTMLIFrameElement.contentDocument.get");



// [CheckSecurity=ReturnValue]
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
v8::Local<v8::Object> v8_receiver = info.This();
HTMLIFrameElement* blink_receiver = V8HTMLIFrameElement::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->contentDocument();
static_assert(bindings::IsReturnTypeCompatible<IDLNullable<Document>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
if (!BindingSecurity::ShouldAllowAccessTo(ToLocalDOMWindow(current_context), return_value)) {
  ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
UseCounter::Count(current_execution_context, WebFeature::kCrossOriginHTMLIFrameElementContentDocument);
bindings::V8SetReturnValue(info, nullptr);
return;
}
{
  // [CheckSecurity=ReturnValue]
Frame* blink_frame = blink_receiver->contentWindow()->GetFrame();
DCHECK(IsA<LocalFrame>(blink_frame));
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
if (!blink_frame->IsAttached() && To<LocalFrame>(blink_frame)->WindowProxyMaybeUninitialized(script_state->World())->ContextIfInitialized().IsEmpty()) [[unlikely]] {
  // Don't wrap the return value if its frame is in the process of detaching and
// has already invalidated its v8::Context, as it is not safe to
// re-initialize the v8::Context in that state. Return null instead.
bindings::V8SetReturnValue(info, nullptr);
return;
}
v8::Local<v8::Value> v8_value = ToV8Traits<IDLNullable<Document>>::ToV8(ToScriptState(To<LocalFrame>(blink_frame), script_state->World()),return_value);
bindings::V8SetReturnValue(info, v8_value);
}
}



void ContentWindowAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLIFrameElement_contentWindow_Getter");
BLINK_BINDINGS_TRACE_EVENT("HTMLIFrameElement.contentWindow.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
HTMLIFrameElement* blink_receiver = V8HTMLIFrameElement::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->contentWindow();
static_assert(bindings::IsReturnTypeCompatible<IDLNullable<DOMWindow>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver, bindings::V8ReturnValue::kMaybeCrossOrigin);
}



void ReferrerPolicyAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLIFrameElement_referrerPolicy_Getter");
BLINK_BINDINGS_TRACE_EVENT("HTMLIFrameElement.referrerPolicy.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
HTMLIFrameElement* blink_receiver = V8HTMLIFrameElement::ToWrappableUnsafe(isolate, v8_receiver);
auto return_value = blink_receiver->FastGetAttribute(html_names::kReferrerpolicyAttr);

// [ReflectOnly]
const AtomicString reflect_value(return_value.LowerASCII());
if (reflect_value.IsNull()) {
  return_value = g_empty_atom;
} else if (reflect_value == g_empty_atom || reflect_value == keywords::kNoReferrer || reflect_value == keywords::kOrigin || reflect_value == keywords::kNoReferrerWhenDowngrade || reflect_value == keywords::kOriginWhenCrossOrigin || reflect_value == keywords::kUnsafeUrl) {
  return_value = reflect_value;
} else {
  return_value = g_empty_atom;
}  
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNonNullable);
}

void ReferrerPolicyAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLIFrameElement_referrerPolicy_Setter");
BLINK_BINDINGS_TRACE_EVENT("HTMLIFrameElement.referrerPolicy.set");

bindings::PerformAttributeSetCEReactionsReflectTypeString(info, html_names::kReferrerpolicyAttr);
}


void CspAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLIFrameElement_csp_Getter");
BLINK_BINDINGS_TRACE_EVENT("HTMLIFrameElement.csp.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
HTMLIFrameElement* blink_receiver = V8HTMLIFrameElement::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->FastGetAttribute(html_names::kCspAttr);
static_assert(bindings::IsReturnTypeCompatible<IDLString, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNonNullable);
}

void CspAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLIFrameElement_csp_Setter");
BLINK_BINDINGS_TRACE_EVENT("HTMLIFrameElement.csp.set");

bindings::PerformAttributeSetCEReactionsReflectTypeString(info, html_names::kCspAttr);
}


void AllowAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLIFrameElement_allow_Getter");
BLINK_BINDINGS_TRACE_EVENT("HTMLIFrameElement.allow.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
HTMLIFrameElement* blink_receiver = V8HTMLIFrameElement::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->FastGetAttribute(html_names::kAllowAttr);
static_assert(bindings::IsReturnTypeCompatible<IDLString, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNonNullable);
}

void AllowAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLIFrameElement_allow_Setter");
BLINK_BINDINGS_TRACE_EVENT("HTMLIFrameElement.allow.set");

bindings::PerformAttributeSetCEReactionsReflectTypeString(info, html_names::kAllowAttr);
}


void FeaturePolicyAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLIFrameElement_featurePolicy_Getter");
BLINK_BINDINGS_TRACE_EVENT("HTMLIFrameElement.featurePolicy.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
HTMLIFrameElement* blink_receiver = V8HTMLIFrameElement::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->featurePolicy();
static_assert(bindings::IsReturnTypeCompatible<DOMFeaturePolicy, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}



void PolicyAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLIFrameElement_policy_Getter");
BLINK_BINDINGS_TRACE_EVENT("HTMLIFrameElement.policy.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
HTMLIFrameElement* blink_receiver = V8HTMLIFrameElement::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->FastGetAttribute(html_names::kPolicyAttr);
static_assert(bindings::IsReturnTypeCompatible<IDLString, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNonNullable);
}

void PolicyAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLIFrameElement_policy_Setter");
BLINK_BINDINGS_TRACE_EVENT("HTMLIFrameElement.policy.set");

bindings::PerformAttributeSetCEReactionsReflectTypeString(info, html_names::kPolicyAttr);
}


void LoadingAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLIFrameElement_loading_Getter");
BLINK_BINDINGS_TRACE_EVENT("HTMLIFrameElement.loading.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
HTMLIFrameElement* blink_receiver = V8HTMLIFrameElement::ToWrappableUnsafe(isolate, v8_receiver);
auto return_value = blink_receiver->FastGetAttribute(html_names::kLoadingAttr);

// [ReflectOnly]
const AtomicString reflect_value(return_value.LowerASCII());
if (reflect_value.IsNull()) {
  return_value = keywords::kAuto;
} else if (reflect_value == keywords::kLazy || reflect_value == keywords::kEager || reflect_value == keywords::kAuto) {
  return_value = reflect_value;
} else {
  return_value = keywords::kAuto;
}  
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNonNullable);
}

void LoadingAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLIFrameElement_loading_Setter");
BLINK_BINDINGS_TRACE_EVENT("HTMLIFrameElement.loading.set");

bindings::PerformAttributeSetCEReactionsReflectTypeString(info, html_names::kLoadingAttr);
}


void PrivateTokenAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLIFrameElement_privateToken_Getter");
BLINK_BINDINGS_TRACE_EVENT("HTMLIFrameElement.privateToken.get");
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kTrustTokenIframe);



v8::Local<v8::Object> v8_receiver = info.This();
HTMLIFrameElement* blink_receiver = V8HTMLIFrameElement::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->FastGetAttribute(html_names::kPrivatetokenAttr);
static_assert(bindings::IsReturnTypeCompatible<IDLString, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNonNullable);
}

void PrivateTokenAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLIFrameElement_privateToken_Setter");
BLINK_BINDINGS_TRACE_EVENT("HTMLIFrameElement.privateToken.set");
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kTrustTokenIframe);


v8::Local<v8::Object> v8_receiver = info.This();
HTMLIFrameElement* blink_receiver = V8HTMLIFrameElement::ToWrappableUnsafe(isolate, v8_receiver);
v8::Local<v8::Value> v8_property_value = info[0];
ExceptionState exception_state(isolate);
auto&& arg1_value = NativeValueTraits<IDLString>::NativeValue(isolate, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setAttribute(html_names::kPrivatetokenAttr, arg1_value);

}


void BrowsingTopicsAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLIFrameElement_browsingTopics_Getter");
BLINK_BINDINGS_TRACE_EVENT("HTMLIFrameElement.browsingTopics.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
HTMLIFrameElement* blink_receiver = V8HTMLIFrameElement::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->FastHasAttribute(html_names::kBrowsingtopicsAttr);
static_assert(bindings::IsReturnTypeCompatible<IDLBoolean, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<bool>());
}

void BrowsingTopicsAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLIFrameElement_browsingTopics_Setter");
BLINK_BINDINGS_TRACE_EVENT("HTMLIFrameElement.browsingTopics.set");

bindings::PerformAttributeSetCEReactionsReflectTypeBoolean(info, html_names::kBrowsingtopicsAttr);
}


void AdAuctionHeadersAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLIFrameElement_adAuctionHeaders_Getter");
BLINK_BINDINGS_TRACE_EVENT("HTMLIFrameElement.adAuctionHeaders.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
HTMLIFrameElement* blink_receiver = V8HTMLIFrameElement::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->FastHasAttribute(html_names::kAdauctionheadersAttr);
static_assert(bindings::IsReturnTypeCompatible<IDLBoolean, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<bool>());
}

void AdAuctionHeadersAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLIFrameElement_adAuctionHeaders_Setter");
BLINK_BINDINGS_TRACE_EVENT("HTMLIFrameElement.adAuctionHeaders.set");

bindings::PerformAttributeSetCEReactionsReflectTypeBoolean(info, html_names::kAdauctionheadersAttr);
}


void CredentiallessAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLIFrameElement_credentialless_Getter");
BLINK_BINDINGS_TRACE_EVENT("HTMLIFrameElement.credentialless.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
HTMLIFrameElement* blink_receiver = V8HTMLIFrameElement::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->FastHasAttribute(html_names::kCredentiallessAttr);
static_assert(bindings::IsReturnTypeCompatible<IDLBoolean, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<bool>());
}

void CredentiallessAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLIFrameElement_credentialless_Setter");
BLINK_BINDINGS_TRACE_EVENT("HTMLIFrameElement.credentialless.set");

bindings::PerformAttributeSetCEReactionsReflectTypeBoolean(info, html_names::kCredentiallessAttr);
}


void AlignAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLIFrameElement_align_Getter");
BLINK_BINDINGS_TRACE_EVENT("HTMLIFrameElement.align.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
HTMLIFrameElement* blink_receiver = V8HTMLIFrameElement::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->FastGetAttribute(html_names::kAlignAttr);
static_assert(bindings::IsReturnTypeCompatible<IDLString, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNonNullable);
}

void AlignAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLIFrameElement_align_Setter");
BLINK_BINDINGS_TRACE_EVENT("HTMLIFrameElement.align.set");

bindings::PerformAttributeSetCEReactionsReflectTypeString(info, html_names::kAlignAttr);
}


void ScrollingAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLIFrameElement_scrolling_Getter");
BLINK_BINDINGS_TRACE_EVENT("HTMLIFrameElement.scrolling.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
HTMLIFrameElement* blink_receiver = V8HTMLIFrameElement::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->FastGetAttribute(html_names::kScrollingAttr);
static_assert(bindings::IsReturnTypeCompatible<IDLString, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNonNullable);
}

void ScrollingAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLIFrameElement_scrolling_Setter");
BLINK_BINDINGS_TRACE_EVENT("HTMLIFrameElement.scrolling.set");

bindings::PerformAttributeSetCEReactionsReflectTypeString(info, html_names::kScrollingAttr);
}


void FrameBorderAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLIFrameElement_frameBorder_Getter");
BLINK_BINDINGS_TRACE_EVENT("HTMLIFrameElement.frameBorder.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
HTMLIFrameElement* blink_receiver = V8HTMLIFrameElement::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->FastGetAttribute(html_names::kFrameborderAttr);
static_assert(bindings::IsReturnTypeCompatible<IDLString, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNonNullable);
}

void FrameBorderAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLIFrameElement_frameBorder_Setter");
BLINK_BINDINGS_TRACE_EVENT("HTMLIFrameElement.frameBorder.set");

bindings::PerformAttributeSetCEReactionsReflectTypeString(info, html_names::kFrameborderAttr);
}


void LongDescAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLIFrameElement_longDesc_Getter");
BLINK_BINDINGS_TRACE_EVENT("HTMLIFrameElement.longDesc.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
HTMLIFrameElement* blink_receiver = V8HTMLIFrameElement::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->GetURLAttribute(html_names::kLongdescAttr);
static_assert(bindings::IsReturnTypeCompatible<IDLUSVString, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNonNullable);
}

void LongDescAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLIFrameElement_longDesc_Setter");
BLINK_BINDINGS_TRACE_EVENT("HTMLIFrameElement.longDesc.set");

v8::Isolate* isolate = info.GetIsolate();
ExceptionState exception_state(isolate);

// [CEReactions]
CEReactionsScope ce_reactions_scope(isolate);

v8::Local<v8::Object> v8_receiver = info.This();
HTMLIFrameElement* blink_receiver = V8HTMLIFrameElement::ToWrappableUnsafe(isolate, v8_receiver);
v8::Local<v8::Value> v8_property_value = info[0];
auto&& arg1_value = NativeValueTraits<IDLUSVString>::NativeValue(isolate, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setAttribute(html_names::kLongdescAttr, arg1_value);

}


void MarginHeightAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLIFrameElement_marginHeight_Getter");
BLINK_BINDINGS_TRACE_EVENT("HTMLIFrameElement.marginHeight.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
HTMLIFrameElement* blink_receiver = V8HTMLIFrameElement::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->FastGetAttribute(html_names::kMarginheightAttr);
static_assert(bindings::IsReturnTypeCompatible<IDLStringLegacyNullToEmptyString, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNonNullable);
}

void MarginHeightAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLIFrameElement_marginHeight_Setter");
BLINK_BINDINGS_TRACE_EVENT("HTMLIFrameElement.marginHeight.set");

bindings::PerformAttributeSetCEReactionsReflectTypeStringLegacyNullToEmptyString(info, html_names::kMarginheightAttr);
}


void MarginWidthAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLIFrameElement_marginWidth_Getter");
BLINK_BINDINGS_TRACE_EVENT("HTMLIFrameElement.marginWidth.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
HTMLIFrameElement* blink_receiver = V8HTMLIFrameElement::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->FastGetAttribute(html_names::kMarginwidthAttr);
static_assert(bindings::IsReturnTypeCompatible<IDLStringLegacyNullToEmptyString, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNonNullable);
}

void MarginWidthAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLIFrameElement_marginWidth_Setter");
BLINK_BINDINGS_TRACE_EVENT("HTMLIFrameElement.marginWidth.set");

bindings::PerformAttributeSetCEReactionsReflectTypeStringLegacyNullToEmptyString(info, html_names::kMarginwidthAttr);
}


void AllowPaymentRequestAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLIFrameElement_allowPaymentRequest_Getter");
BLINK_BINDINGS_TRACE_EVENT("HTMLIFrameElement.allowPaymentRequest.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
HTMLIFrameElement* blink_receiver = V8HTMLIFrameElement::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = HTMLIFrameElementPayments::FastHasAttribute(*blink_receiver, html_names::kAllowpaymentrequestAttr);
static_assert(bindings::IsReturnTypeCompatible<IDLBoolean, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<bool>());
}

void AllowPaymentRequestAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLIFrameElement_allowPaymentRequest_Setter");
BLINK_BINDINGS_TRACE_EVENT("HTMLIFrameElement.allowPaymentRequest.set");

bindings::PerformAttributeSetCEReactionsReflectTypeBoolean(info, html_names::kAllowpaymentrequestAttr);
}


void SharedStorageWritableAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLIFrameElement_sharedStorageWritable_Getter");
BLINK_BINDINGS_TRACE_EVENT("HTMLIFrameElement.sharedStorageWritable.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
HTMLIFrameElement* blink_receiver = V8HTMLIFrameElement::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->FastHasAttribute(html_names::kSharedstoragewritableAttr);
static_assert(bindings::IsReturnTypeCompatible<IDLBoolean, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<bool>());
}

void SharedStorageWritableAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLIFrameElement_sharedStorageWritable_Setter");
BLINK_BINDINGS_TRACE_EVENT("HTMLIFrameElement.sharedStorageWritable.set");

bindings::PerformAttributeSetCEReactionsReflectTypeBoolean(info, html_names::kSharedstoragewritableAttr);
}

void ConstructorCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLIFrameElement_constructor");
BLINK_BINDINGS_TRACE_EVENT("HTMLIFrameElement.constructor");

v8::Isolate* isolate = info.GetIsolate();
if (!info.IsConstructCall()) {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::ConstructorCalledAsFunction());
return;
}
if (ConstructorMode::Current(isolate) == ConstructorMode::kWrapExistingObject) {
  v8::Local<v8::Object> v8_receiver = info.This();
bindings::V8SetReturnValue(info, v8_receiver);
return;
}



// [HTMLConstructor]
V8HTMLConstructor::HtmlConstructor(info, *V8HTMLIFrameElement::GetWrapperTypeInfo(), HTMLElementType::kHTMLIFrameElement);
}

void GetSVGDocumentOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLIFrameElement_getSVGDocument");
BLINK_BINDINGS_TRACE_EVENT("HTMLIFrameElement.getSVGDocument");






// [CheckSecurity=ReturnValue]
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
v8::Local<v8::Object> v8_receiver = info.This();
HTMLIFrameElement* blink_receiver = V8HTMLIFrameElement::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->getSVGDocument();
static_assert(bindings::IsReturnTypeCompatible<IDLNullable<Document>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
if (!BindingSecurity::ShouldAllowAccessTo(ToLocalDOMWindow(current_context), return_value)) {
  ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
UseCounter::Count(current_execution_context, WebFeature::kCrossOriginHTMLIFrameElementGetSVGDocument);
bindings::V8SetReturnValue(info, nullptr);
return;
}
{
  // [CheckSecurity=ReturnValue]
Frame* blink_frame = blink_receiver->contentWindow()->GetFrame();
DCHECK(IsA<LocalFrame>(blink_frame));
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
if (!blink_frame->IsAttached() && To<LocalFrame>(blink_frame)->WindowProxyMaybeUninitialized(script_state->World())->ContextIfInitialized().IsEmpty()) [[unlikely]] {
  // Don't wrap the return value if its frame is in the process of detaching and
// has already invalidated its v8::Context, as it is not safe to
// re-initialize the v8::Context in that state. Return null instead.
bindings::V8SetReturnValue(info, nullptr);
return;
}
v8::Local<v8::Value> v8_value = ToV8Traits<IDLNullable<Document>>::ToV8(ToScriptState(To<LocalFrame>(blink_frame), script_state->World()),return_value);
bindings::V8SetReturnValue(info, v8_value);
}
}


}  // namespace v8_html_iframe_element

using namespace v8_html_iframe_element;

}  // namespace 

void V8HTMLIFrameElement::Impl::InstallInterfaceTemplate(v8::Isolate* isolate, const DOMWrapperWorld& world, v8::Local<v8::Template> interface_template) {
  const WrapperTypeInfo* const wrapper_type_info = V8HTMLIFrameElement::GetWrapperTypeInfo();
v8::Local<v8::FunctionTemplate> interface_function_template = interface_template.As<v8::FunctionTemplate>();
v8::Local<v8::ObjectTemplate> instance_template = interface_function_template->InstanceTemplate();
v8::Local<v8::ObjectTemplate> prototype_template = interface_function_template->PrototypeTemplate();
v8::Local<v8::FunctionTemplate> parent_interface_template = wrapper_type_info->parent_class->GetV8ClassTemplate(isolate, world).As<v8::FunctionTemplate>();
bindings::SetupIDLInterfaceTemplate(isolate, wrapper_type_info, instance_template, prototype_template, interface_function_template, parent_interface_template);

interface_function_template->SetCallHandler(ConstructorCallback);
interface_function_template->SetLength(0);
interface_function_template->SetInterfaceName(V8String(isolate, "HTMLIFrameElement"));
interface_function_template->SetExceptionContext(v8::ExceptionContext::kConstructor);






InstallUnconditionalProperties(isolate, world, instance_template, prototype_template, interface_template);
InstallContextIndependentProperties(isolate, world, instance_template, prototype_template, interface_template);
}

void V8HTMLIFrameElement::Impl::InstallUnconditionalProperties(v8::Isolate* isolate, const DOMWrapperWorld& world, v8::Local<v8::ObjectTemplate> instance_template, v8::Local<v8::ObjectTemplate> prototype_template, v8::Local<v8::Template> interface_template) {
  using bindings::IDLMemberInstaller;

v8::Local<v8::Signature> signature = v8::Local<v8::Signature>::Cast(interface_template);
{
  
static const IDLMemberInstaller::AttributeConfig kAttributeTable[] = {
{"src", SrcAttributeGetCallback, SrcAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"srcdoc", SrcdocAttributeGetCallback, SrcdocAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"name", NameAttributeGetCallback, NameAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"sandbox", SandboxAttributeGetCallback, SandboxAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"allowFullscreen", AllowFullscreenAttributeGetCallback, AllowFullscreenAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"width", WidthAttributeGetCallback, WidthAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"height", HeightAttributeGetCallback, HeightAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"contentDocument", ContentDocumentAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"contentWindow", ContentWindowAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"referrerPolicy", ReferrerPolicyAttributeGetCallback, ReferrerPolicyAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"csp", CspAttributeGetCallback, CspAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"allow", AllowAttributeGetCallback, AllowAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"featurePolicy", FeaturePolicyAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"loading", LoadingAttributeGetCallback, LoadingAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"align", AlignAttributeGetCallback, AlignAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"scrolling", ScrollingAttributeGetCallback, ScrollingAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"frameBorder", FrameBorderAttributeGetCallback, FrameBorderAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"longDesc", LongDescAttributeGetCallback, LongDescAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"marginHeight", MarginHeightAttributeGetCallback, MarginHeightAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"marginWidth", MarginWidthAttributeGetCallback, MarginWidthAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
};
IDLMemberInstaller::InstallAttributes(isolate, world, instance_template, prototype_template, interface_template, signature, "HTMLIFrameElement", kAttributeTable);
}





{
  static const IDLMemberInstaller::OperationConfig kOperationTable[] = {
{"getSVGDocument", GetSVGDocumentOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
};
IDLMemberInstaller::InstallOperations(isolate, world, instance_template, prototype_template, interface_template, signature, "HTMLIFrameElement", kOperationTable);
}



}

void V8HTMLIFrameElement::Impl::InstallContextIndependentProperties(v8::Isolate* isolate, const DOMWrapperWorld& world, v8::Local<v8::ObjectTemplate> instance_template, v8::Local<v8::ObjectTemplate> prototype_template, v8::Local<v8::Template> interface_template) {
  using bindings::IDLMemberInstaller;

v8::Local<v8::Signature> signature = v8::Local<v8::Signature>::Cast(interface_template);
if (RuntimeEnabledFeatures::AnonymousIframeEnabled()) {
  
static const IDLMemberInstaller::AttributeConfig kAttributeTable[] = {
{"credentialless", CredentiallessAttributeGetCallback, CredentiallessAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
};
IDLMemberInstaller::InstallAttributes(isolate, world, instance_template, prototype_template, interface_template, signature, "HTMLIFrameElement", kAttributeTable);
}
if (RuntimeEnabledFeatures::PaymentRequestEnabled()) {
  
static const IDLMemberInstaller::AttributeConfig kAttributeTable[] = {
{"allowPaymentRequest", AllowPaymentRequestAttributeGetCallback, AllowPaymentRequestAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
};
IDLMemberInstaller::InstallAttributes(isolate, world, instance_template, prototype_template, interface_template, signature, "HTMLIFrameElement", kAttributeTable);
}






}

void V8HTMLIFrameElement::Impl::InstallContextDependentProperties(v8::Local<v8::Context> context, const DOMWrapperWorld& world, v8::Local<v8::Object> instance_object, v8::Local<v8::Object> prototype_object, v8::Local<v8::Object> interface_object, v8::Local<v8::Template> interface_template, FeatureSelector feature_selector) {
  using bindings::IDLMemberInstaller;

v8::Isolate* isolate = v8::Isolate::GetCurrent();
ScriptState* script_state = ScriptState::From(isolate, context);
ExecutionContext* execution_context = ToExecutionContext(script_state);
v8::Local<v8::Signature> signature = v8::Local<v8::Signature>::Cast(interface_template);
if ((feature_selector.IsAll() && RuntimeEnabledFeatures::DocumentPolicyNegotiationEnabled(execution_context)) || feature_selector.IsAnyOf(mojom::blink::OriginTrialFeature::kDocumentPolicyNegotiation)) {
  
static const IDLMemberInstaller::AttributeConfig kAttributeTable[] = {
{"policy", PolicyAttributeGetCallback, PolicyAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
};
IDLMemberInstaller::InstallAttributes(isolate, world, instance_object, prototype_object, interface_object, signature, "HTMLIFrameElement", kAttributeTable);
}
const bool is_in_secure_context = execution_context->IsSecureContext();
if (is_in_secure_context && (feature_selector.IsAll() && RuntimeEnabledFeatures::PrivateStateTokensEnabled())) {
  
static const IDLMemberInstaller::AttributeConfig kAttributeTable[] = {
{"privateToken", PrivateTokenAttributeGetCallback, PrivateTokenAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
};
IDLMemberInstaller::InstallAttributes(isolate, world, instance_object, prototype_object, interface_object, signature, "HTMLIFrameElement", kAttributeTable);
}
if (is_in_secure_context && (feature_selector.IsAll() && RuntimeEnabledFeatures::TopicsAPIEnabled())) {
  
static const IDLMemberInstaller::AttributeConfig kAttributeTable[] = {
{"browsingTopics", BrowsingTopicsAttributeGetCallback, BrowsingTopicsAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
};
IDLMemberInstaller::InstallAttributes(isolate, world, instance_object, prototype_object, interface_object, signature, "HTMLIFrameElement", kAttributeTable);
}
if (is_in_secure_context && feature_selector.IsAll()) {
  
static const IDLMemberInstaller::AttributeConfig kAttributeTable[] = {
{"adAuctionHeaders", AdAuctionHeadersAttributeGetCallback, AdAuctionHeadersAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
};
IDLMemberInstaller::InstallAttributes(isolate, world, instance_object, prototype_object, interface_object, signature, "HTMLIFrameElement", kAttributeTable);
}
if (is_in_secure_context && (feature_selector.IsAll() && RuntimeEnabledFeatures::SharedStorageAPIEnabled())) {
  
static const IDLMemberInstaller::AttributeConfig kAttributeTable[] = {
{"sharedStorageWritable", SharedStorageWritableAttributeGetCallback, SharedStorageWritableAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
};
IDLMemberInstaller::InstallAttributes(isolate, world, instance_object, prototype_object, interface_object, signature, "HTMLIFrameElement", kAttributeTable);
}






}


}  // namespace blink
