// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_HID_DEVICE_FILTER_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_HID_DEVICE_FILTER_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT HIDDeviceFilter : public bindings::InputDictionaryBase {
  
  public:
static HIDDeviceFilter* Create() {
  return MakeGarbageCollected<HIDDeviceFilter>();
}
static HIDDeviceFilter* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<HIDDeviceFilter>(isolate);
}
static HIDDeviceFilter* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  HIDDeviceFilter();
explicit  HIDDeviceFilter(v8::Isolate* isolate);

bool hasProductId() const {
  return has_product_id_;
}
uint16_t productId() const {
  DCHECK(hasProductId());
return member_product_id_;
}
uint16_t getProductIdOr(uint16_t fallback_value) const {
  if (!hasProductId()) {
  return fallback_value;
}
return member_product_id_;
}
void setProductId(uint16_t value) {
  member_product_id_ = value;
has_product_id_ = true;
}

bool hasUsage() const {
  return has_usage_;
}
uint16_t usage() const {
  DCHECK(hasUsage());
return member_usage_;
}
uint16_t getUsageOr(uint16_t fallback_value) const {
  if (!hasUsage()) {
  return fallback_value;
}
return member_usage_;
}
void setUsage(uint16_t value) {
  member_usage_ = value;
has_usage_ = true;
}

bool hasUsagePage() const {
  return has_usage_page_;
}
uint16_t usagePage() const {
  DCHECK(hasUsagePage());
return member_usage_page_;
}
uint16_t getUsagePageOr(uint16_t fallback_value) const {
  if (!hasUsagePage()) {
  return fallback_value;
}
return member_usage_page_;
}
void setUsagePage(uint16_t value) {
  member_usage_page_ = value;
has_usage_page_ = true;
}

bool hasVendorId() const {
  return has_vendor_id_;
}
uint32_t vendorId() const {
  DCHECK(hasVendorId());
return member_vendor_id_;
}
uint32_t getVendorIdOr(uint32_t fallback_value) const {
  if (!hasVendorId()) {
  return fallback_value;
}
return member_vendor_id_;
}
void setVendorId(uint32_t value) {
  member_vendor_id_ = value;
has_vendor_id_ = true;
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 4;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_product_id_ = false;
bool has_usage_ = false;
bool has_usage_page_ = false;
bool has_vendor_id_ = false;

uint16_t member_product_id_;
uint16_t member_usage_;
uint16_t member_usage_page_;
uint32_t member_vendor_id_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_HID_DEVICE_FILTER_H_
