// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_HID_COLLECTION_INFO_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_HID_COLLECTION_INFO_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class HIDCollectionInfo;
class HIDReportInfo;

class MODULES_EXPORT HIDCollectionInfo : public bindings::DictionaryBase {
  
  public:
static HIDCollectionInfo* Create() {
  return MakeGarbageCollected<HIDCollectionInfo>();
}
static HIDCollectionInfo* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<HIDCollectionInfo>(isolate);
}
static HIDCollectionInfo* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  HIDCollectionInfo();
explicit  HIDCollectionInfo(v8::Isolate* isolate);

bool hasChildren() const {
  return has_children_;
}
const HeapVector<Member<HIDCollectionInfo>>& children() const {
  DCHECK(hasChildren());
return member_children_;
}
HeapVector<Member<HIDCollectionInfo>> getChildrenOr(const HeapVector<Member<HIDCollectionInfo>>& fallback_value) const;
HeapVector<Member<HIDCollectionInfo>> getChildrenOr(HeapVector<Member<HIDCollectionInfo>>&& fallback_value) const;
void setChildren(const HeapVector<Member<HIDCollectionInfo>>& value);
void setChildren(HeapVector<Member<HIDCollectionInfo>>&& value);

bool hasFeatureReports() const {
  return has_feature_reports_;
}
const HeapVector<Member<HIDReportInfo>>& featureReports() const {
  DCHECK(hasFeatureReports());
return member_feature_reports_;
}
HeapVector<Member<HIDReportInfo>> getFeatureReportsOr(const HeapVector<Member<HIDReportInfo>>& fallback_value) const;
HeapVector<Member<HIDReportInfo>> getFeatureReportsOr(HeapVector<Member<HIDReportInfo>>&& fallback_value) const;
void setFeatureReports(const HeapVector<Member<HIDReportInfo>>& value);
void setFeatureReports(HeapVector<Member<HIDReportInfo>>&& value);

bool hasInputReports() const {
  return has_input_reports_;
}
const HeapVector<Member<HIDReportInfo>>& inputReports() const {
  DCHECK(hasInputReports());
return member_input_reports_;
}
HeapVector<Member<HIDReportInfo>> getInputReportsOr(const HeapVector<Member<HIDReportInfo>>& fallback_value) const;
HeapVector<Member<HIDReportInfo>> getInputReportsOr(HeapVector<Member<HIDReportInfo>>&& fallback_value) const;
void setInputReports(const HeapVector<Member<HIDReportInfo>>& value);
void setInputReports(HeapVector<Member<HIDReportInfo>>&& value);

bool hasOutputReports() const {
  return has_output_reports_;
}
const HeapVector<Member<HIDReportInfo>>& outputReports() const {
  DCHECK(hasOutputReports());
return member_output_reports_;
}
HeapVector<Member<HIDReportInfo>> getOutputReportsOr(const HeapVector<Member<HIDReportInfo>>& fallback_value) const;
HeapVector<Member<HIDReportInfo>> getOutputReportsOr(HeapVector<Member<HIDReportInfo>>&& fallback_value) const;
void setOutputReports(const HeapVector<Member<HIDReportInfo>>& value);
void setOutputReports(HeapVector<Member<HIDReportInfo>>&& value);

bool hasType() const {
  return has_type_;
}
uint8_t type() const {
  DCHECK(hasType());
return member_type_;
}
uint8_t getTypeOr(uint8_t fallback_value) const {
  if (!hasType()) {
  return fallback_value;
}
return member_type_;
}
void setType(uint8_t value) {
  member_type_ = value;
has_type_ = true;
}

bool hasUsage() const {
  return has_usage_;
}
uint16_t usage() const {
  DCHECK(hasUsage());
return member_usage_;
}
uint16_t getUsageOr(uint16_t fallback_value) const {
  if (!hasUsage()) {
  return fallback_value;
}
return member_usage_;
}
void setUsage(uint16_t value) {
  member_usage_ = value;
has_usage_ = true;
}

bool hasUsagePage() const {
  return has_usage_page_;
}
uint16_t usagePage() const {
  DCHECK(hasUsagePage());
return member_usage_page_;
}
uint16_t getUsagePageOr(uint16_t fallback_value) const {
  if (!hasUsagePage()) {
  return fallback_value;
}
return member_usage_page_;
}
void setUsagePage(uint16_t value) {
  member_usage_page_ = value;
has_usage_page_ = true;
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 7;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_children_ = false;
bool has_feature_reports_ = false;
bool has_input_reports_ = false;
bool has_output_reports_ = false;
bool has_type_ = false;
bool has_usage_ = false;
bool has_usage_page_ = false;

HeapVector<Member<HIDCollectionInfo>> member_children_;
HeapVector<Member<HIDReportInfo>> member_feature_reports_;
HeapVector<Member<HIDReportInfo>> member_input_reports_;
HeapVector<Member<HIDReportInfo>> member_output_reports_;
uint8_t member_type_;
uint16_t member_usage_;
uint16_t member_usage_page_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_HID_COLLECTION_INFO_H_
