// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_hid_collection_info.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_hid_collection_info.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_hid_report_info.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"children",
"featureReports",
"inputReports",
"outputReports",
"type",
"usage",
"usagePage",
};


}  // namespace 

HIDCollectionInfo* HIDCollectionInfo::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  HIDCollectionInfo* dictionary = MakeGarbageCollected<HIDCollectionInfo>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "HIDCollectionInfo";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 HIDCollectionInfo::HIDCollectionInfo() {
  
}

 HIDCollectionInfo::HIDCollectionInfo(v8::Isolate* isolate) {
  
}



HeapVector<Member<HIDCollectionInfo>> HIDCollectionInfo::getChildrenOr(const HeapVector<Member<HIDCollectionInfo>>& fallback_value) const {
  if (!hasChildren()) {
  return fallback_value;
}
return member_children_;
}

HeapVector<Member<HIDCollectionInfo>> HIDCollectionInfo::getChildrenOr(HeapVector<Member<HIDCollectionInfo>>&& fallback_value) const {
  if (!hasChildren()) {
  return std::move(fallback_value);
}
return member_children_;
}

void HIDCollectionInfo::setChildren(const HeapVector<Member<HIDCollectionInfo>>& value) {
  member_children_ = value;
has_children_ = true;
}

void HIDCollectionInfo::setChildren(HeapVector<Member<HIDCollectionInfo>>&& value) {
  member_children_ = std::move(value);
has_children_ = true;
}




HeapVector<Member<HIDReportInfo>> HIDCollectionInfo::getFeatureReportsOr(const HeapVector<Member<HIDReportInfo>>& fallback_value) const {
  if (!hasFeatureReports()) {
  return fallback_value;
}
return member_feature_reports_;
}

HeapVector<Member<HIDReportInfo>> HIDCollectionInfo::getFeatureReportsOr(HeapVector<Member<HIDReportInfo>>&& fallback_value) const {
  if (!hasFeatureReports()) {
  return std::move(fallback_value);
}
return member_feature_reports_;
}

void HIDCollectionInfo::setFeatureReports(const HeapVector<Member<HIDReportInfo>>& value) {
  member_feature_reports_ = value;
has_feature_reports_ = true;
}

void HIDCollectionInfo::setFeatureReports(HeapVector<Member<HIDReportInfo>>&& value) {
  member_feature_reports_ = std::move(value);
has_feature_reports_ = true;
}




HeapVector<Member<HIDReportInfo>> HIDCollectionInfo::getInputReportsOr(const HeapVector<Member<HIDReportInfo>>& fallback_value) const {
  if (!hasInputReports()) {
  return fallback_value;
}
return member_input_reports_;
}

HeapVector<Member<HIDReportInfo>> HIDCollectionInfo::getInputReportsOr(HeapVector<Member<HIDReportInfo>>&& fallback_value) const {
  if (!hasInputReports()) {
  return std::move(fallback_value);
}
return member_input_reports_;
}

void HIDCollectionInfo::setInputReports(const HeapVector<Member<HIDReportInfo>>& value) {
  member_input_reports_ = value;
has_input_reports_ = true;
}

void HIDCollectionInfo::setInputReports(HeapVector<Member<HIDReportInfo>>&& value) {
  member_input_reports_ = std::move(value);
has_input_reports_ = true;
}




HeapVector<Member<HIDReportInfo>> HIDCollectionInfo::getOutputReportsOr(const HeapVector<Member<HIDReportInfo>>& fallback_value) const {
  if (!hasOutputReports()) {
  return fallback_value;
}
return member_output_reports_;
}

HeapVector<Member<HIDReportInfo>> HIDCollectionInfo::getOutputReportsOr(HeapVector<Member<HIDReportInfo>>&& fallback_value) const {
  if (!hasOutputReports()) {
  return std::move(fallback_value);
}
return member_output_reports_;
}

void HIDCollectionInfo::setOutputReports(const HeapVector<Member<HIDReportInfo>>& value) {
  member_output_reports_ = value;
has_output_reports_ = true;
}

void HIDCollectionInfo::setOutputReports(HeapVector<Member<HIDReportInfo>>&& value) {
  member_output_reports_ = std::move(value);
has_output_reports_ = true;
}

























void HIDCollectionInfo::Trace(Visitor* visitor) const {
  visitor->Trace(member_children_);
visitor->Trace(member_feature_reports_);
visitor->Trace(member_input_reports_);
visitor->Trace(member_output_reports_);
bindings::DictionaryBase::Trace(visitor);
}

void HIDCollectionInfo::FillTemplateProperties(Vector<std::string_view>& properties) const {
  static_assert(std::size(kOwnPropertyNames) == kOwnPropertyCount);
properties.AppendRange(std::cbegin(kOwnPropertyNames), std::cend(kOwnPropertyNames));
DCHECK_EQ(properties.size(), kTotalPropertyCount);
}

void HIDCollectionInfo::FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const {
  CHECK_EQ(kOwnPropertyCount, values.size());
if (hasChildren()) {
  values[0] = ToV8Traits<IDLSequence<HIDCollectionInfo>>::ToV8(script_state, member_children_);
DCHECK(!values[0].IsEmpty());
}
if (hasFeatureReports()) {
  values[1] = ToV8Traits<IDLSequence<HIDReportInfo>>::ToV8(script_state, member_feature_reports_);
DCHECK(!values[1].IsEmpty());
}
if (hasInputReports()) {
  values[2] = ToV8Traits<IDLSequence<HIDReportInfo>>::ToV8(script_state, member_input_reports_);
DCHECK(!values[2].IsEmpty());
}
if (hasOutputReports()) {
  values[3] = ToV8Traits<IDLSequence<HIDReportInfo>>::ToV8(script_state, member_output_reports_);
DCHECK(!values[3].IsEmpty());
}
if (hasType()) {
  values[4] = ToV8Traits<IDLOctet>::ToV8(script_state, member_type_);
DCHECK(!values[4].IsEmpty());
}
if (hasUsage()) {
  values[5] = ToV8Traits<IDLUnsignedShort>::ToV8(script_state, member_usage_);
DCHECK(!values[5].IsEmpty());
}
if (hasUsagePage()) {
  values[6] = ToV8Traits<IDLUnsignedShort>::ToV8(script_state, member_usage_page_);
DCHECK(!values[6].IsEmpty());
}
}

const void* HIDCollectionInfo::TemplateKey() const {
  static const void *s_key = &s_key;
return s_key;
}

v8::Local<v8::Object> HIDCollectionInfo::FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const {
  v8::MaybeLocal<v8::Value> values[kTotalPropertyCount];
FillValuesImpl(script_state, values);
return dict_template->NewInstance(script_state->GetContext(), values);
}

void HIDCollectionInfo::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "HIDCollectionInfo";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("children");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<HIDCollectionInfo>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_children_, member_children_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("featureReports");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<HIDReportInfo>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_feature_reports_, member_feature_reports_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("inputReports");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<HIDReportInfo>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), has_input_reports_, member_input_reports_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("outputReports");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<HIDReportInfo>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), has_output_reports_, member_output_reports_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("type");
if (!bindings::GetDictionaryMemberFromV8Object<IDLOctet, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[4].Get(isolate), has_type_, member_type_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("usage");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedShort, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[5].Get(isolate), has_usage_, member_usage_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("usagePage");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedShort, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[6].Get(isolate), has_usage_page_, member_usage_page_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> HIDCollectionInfo::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
