// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_HANDWRITING_SEGMENT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_HANDWRITING_SEGMENT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;
class HandwritingDrawingSegment;

class MODULES_EXPORT HandwritingSegment : public bindings::DictionaryBase {
  
  public:
static HandwritingSegment* Create() {
  return MakeGarbageCollected<HandwritingSegment>();
}
static HandwritingSegment* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<HandwritingSegment>(isolate);
}
static HandwritingSegment* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  HandwritingSegment();
explicit  HandwritingSegment(v8::Isolate* isolate);

bool hasBeginIndex() const {
  return true;
}
uint32_t beginIndex() const {
  return member_begin_index_;
}
void setBeginIndex(uint32_t value) {
  member_begin_index_ = value;
}

bool hasDrawingSegments() const {
  return true;
}
const HeapVector<Member<HandwritingDrawingSegment>>& drawingSegments() const {
  return member_drawing_segments_;
}
void setDrawingSegments(const HeapVector<Member<HandwritingDrawingSegment>>& value);
void setDrawingSegments(HeapVector<Member<HandwritingDrawingSegment>>&& value);

bool hasEndIndex() const {
  return true;
}
uint32_t endIndex() const {
  return member_end_index_;
}
void setEndIndex(uint32_t value) {
  member_end_index_ = value;
}

bool hasGrapheme() const {
  return true;
}
const String& grapheme() const {
  return member_grapheme_;
}
void setGrapheme(const String& value);
void setGrapheme(String&& value);




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 4;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



uint32_t member_begin_index_;
HeapVector<Member<HandwritingDrawingSegment>> member_drawing_segments_;
uint32_t member_end_index_;
String member_grapheme_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_HANDWRITING_SEGMENT_H_
