// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_HANDWRITING_RECOGNIZER_QUERY_RESULT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_HANDWRITING_RECOGNIZER_QUERY_RESULT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class HandwritingHintsQueryResult;

class MODULES_EXPORT HandwritingRecognizerQueryResult : public bindings::DictionaryBase {
  
  public:
static HandwritingRecognizerQueryResult* Create() {
  return MakeGarbageCollected<HandwritingRecognizerQueryResult>();
}
static HandwritingRecognizerQueryResult* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<HandwritingRecognizerQueryResult>(isolate);
}
static HandwritingRecognizerQueryResult* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  HandwritingRecognizerQueryResult();
explicit  HandwritingRecognizerQueryResult(v8::Isolate* isolate);

bool hasHints() const {
  return has_hints_;
}
HandwritingHintsQueryResult* hints() const {
  DCHECK(hasHints());
return member_hints_.Get();
}
HandwritingHintsQueryResult* getHintsOr(HandwritingHintsQueryResult* fallback_value) const {
  if (!hasHints()) {
  return fallback_value;
}
return member_hints_.Get();
}
void setHints(HandwritingHintsQueryResult* value) {
  member_hints_ = value;
has_hints_ = true;
DCHECK(member_hints_);
}

bool hasTextAlternatives() const {
  return has_text_alternatives_;
}
bool textAlternatives() const {
  DCHECK(hasTextAlternatives());
return member_text_alternatives_;
}
bool getTextAlternativesOr(bool fallback_value) const {
  if (!hasTextAlternatives()) {
  return fallback_value;
}
return member_text_alternatives_;
}
void setTextAlternatives(bool value) {
  member_text_alternatives_ = value;
has_text_alternatives_ = true;
}

bool hasTextSegmentation() const {
  return has_text_segmentation_;
}
bool textSegmentation() const {
  DCHECK(hasTextSegmentation());
return member_text_segmentation_;
}
bool getTextSegmentationOr(bool fallback_value) const {
  if (!hasTextSegmentation()) {
  return fallback_value;
}
return member_text_segmentation_;
}
void setTextSegmentation(bool value) {
  member_text_segmentation_ = value;
has_text_segmentation_ = true;
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 3;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_hints_ = false;
bool has_text_alternatives_ = false;
bool has_text_segmentation_ = false;

Member<HandwritingHintsQueryResult> member_hints_;
bool member_text_alternatives_;
bool member_text_segmentation_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_HANDWRITING_RECOGNIZER_QUERY_RESULT_H_
