// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_VERTEX_ATTRIBUTE_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_VERTEX_ATTRIBUTE_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_vertex_format.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT GPUVertexAttribute : public bindings::InputDictionaryBase {
  
  public:
static GPUVertexAttribute* Create() {
  return MakeGarbageCollected<GPUVertexAttribute>();
}
static GPUVertexAttribute* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<GPUVertexAttribute>(isolate);
}
static GPUVertexAttribute* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  GPUVertexAttribute();
explicit  GPUVertexAttribute(v8::Isolate* isolate);

bool hasFormat() const {
  return true;
}
V8GPUVertexFormat format() const {
  return member_format_;
}
void setFormat(V8GPUVertexFormat value) {
  member_format_ = value;
}
void setFormat(V8GPUVertexFormat::Enum value) {
  member_format_ = V8GPUVertexFormat(value);
}

bool hasOffset() const {
  return true;
}
uint64_t offset() const {
  return member_offset_;
}
void setOffset(uint64_t value) {
  member_offset_ = value;
}

bool hasShaderLocation() const {
  return true;
}
uint32_t shaderLocation() const {
  return member_shader_location_;
}
void setShaderLocation(uint32_t value) {
  member_shader_location_ = value;
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 3;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



V8GPUVertexFormat member_format_{static_cast<V8GPUVertexFormat::Enum>(0)};
uint64_t member_offset_;
uint32_t member_shader_location_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_VERTEX_ATTRIBUTE_H_
