// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_SHADER_MODULE_COMPILATION_HINT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_SHADER_MODULE_COMPILATION_HINT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_auto_layout_mode.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;
class GPUPipelineLayout;
class V8UnionGPUAutoLayoutModeOrGPUPipelineLayout;

class MODULES_EXPORT GPUShaderModuleCompilationHint : public bindings::InputDictionaryBase {
  
  public:
static GPUShaderModuleCompilationHint* Create() {
  return MakeGarbageCollected<GPUShaderModuleCompilationHint>();
}
static GPUShaderModuleCompilationHint* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<GPUShaderModuleCompilationHint>(isolate);
}
static GPUShaderModuleCompilationHint* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  GPUShaderModuleCompilationHint();
explicit  GPUShaderModuleCompilationHint(v8::Isolate* isolate);

bool hasEntryPoint() const {
  return true;
}
const String& entryPoint() const {
  return member_entry_point_;
}
void setEntryPoint(const String& value);
void setEntryPoint(String&& value);

bool hasLayout() const {
  return has_layout_;
}
V8UnionGPUAutoLayoutModeOrGPUPipelineLayout* layout() const {
  DCHECK(hasLayout());
return member_layout_.Get();
}
V8UnionGPUAutoLayoutModeOrGPUPipelineLayout* getLayoutOr(V8UnionGPUAutoLayoutModeOrGPUPipelineLayout* fallback_value) const {
  if (!hasLayout()) {
  return fallback_value;
}
return member_layout_.Get();
}
void setLayout(V8UnionGPUAutoLayoutModeOrGPUPipelineLayout* value) {
  member_layout_ = value;
has_layout_ = true;
DCHECK(member_layout_);
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_layout_ = false;

String member_entry_point_;
Member<V8UnionGPUAutoLayoutModeOrGPUPipelineLayout> member_layout_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_SHADER_MODULE_COMPILATION_HINT_H_
