// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_SAMPLER_DESCRIPTOR_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_SAMPLER_DESCRIPTOR_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_address_mode.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_compare_function.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_filter_mode.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_mipmap_filter_mode.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_object_descriptor_base.h"
#include "third_party/blink/renderer/modules/modules_export.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT GPUSamplerDescriptor : public GPUObjectDescriptorBase {
  
  public:
static GPUSamplerDescriptor* Create() {
  return MakeGarbageCollected<GPUSamplerDescriptor>();
}
static GPUSamplerDescriptor* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<GPUSamplerDescriptor>(isolate);
}
static GPUSamplerDescriptor* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  GPUSamplerDescriptor();
explicit  GPUSamplerDescriptor(v8::Isolate* isolate);

bool hasAddressModeU() const {
  return true;
}
V8GPUAddressMode addressModeU() const {
  return member_address_mode_u_;
}
void setAddressModeU(V8GPUAddressMode value) {
  member_address_mode_u_ = value;
}
void setAddressModeU(V8GPUAddressMode::Enum value) {
  member_address_mode_u_ = V8GPUAddressMode(value);
}

bool hasAddressModeV() const {
  return true;
}
V8GPUAddressMode addressModeV() const {
  return member_address_mode_v_;
}
void setAddressModeV(V8GPUAddressMode value) {
  member_address_mode_v_ = value;
}
void setAddressModeV(V8GPUAddressMode::Enum value) {
  member_address_mode_v_ = V8GPUAddressMode(value);
}

bool hasAddressModeW() const {
  return true;
}
V8GPUAddressMode addressModeW() const {
  return member_address_mode_w_;
}
void setAddressModeW(V8GPUAddressMode value) {
  member_address_mode_w_ = value;
}
void setAddressModeW(V8GPUAddressMode::Enum value) {
  member_address_mode_w_ = V8GPUAddressMode(value);
}

bool hasCompare() const {
  return has_compare_;
}
V8GPUCompareFunction compare() const {
  DCHECK(hasCompare());
return member_compare_;
}
V8GPUCompareFunction getCompareOr(V8GPUCompareFunction fallback_value) const {
  if (!hasCompare()) {
  return fallback_value;
}
return member_compare_;
}
void setCompare(V8GPUCompareFunction value) {
  member_compare_ = value;
has_compare_ = true;
}
void setCompare(V8GPUCompareFunction::Enum value) {
  member_compare_ = V8GPUCompareFunction(value);
has_compare_ = true;
}

bool hasLodMaxClamp() const {
  return true;
}
float lodMaxClamp() const {
  return member_lod_max_clamp_;
}
void setLodMaxClamp(float value) {
  member_lod_max_clamp_ = value;
}

bool hasLodMinClamp() const {
  return true;
}
float lodMinClamp() const {
  return member_lod_min_clamp_;
}
void setLodMinClamp(float value) {
  member_lod_min_clamp_ = value;
}

bool hasMagFilter() const {
  return true;
}
V8GPUFilterMode magFilter() const {
  return member_mag_filter_;
}
void setMagFilter(V8GPUFilterMode value) {
  member_mag_filter_ = value;
}
void setMagFilter(V8GPUFilterMode::Enum value) {
  member_mag_filter_ = V8GPUFilterMode(value);
}

bool hasMaxAnisotropy() const {
  return true;
}
uint16_t maxAnisotropy() const {
  return member_max_anisotropy_;
}
void setMaxAnisotropy(uint16_t value) {
  member_max_anisotropy_ = value;
}

bool hasMinFilter() const {
  return true;
}
V8GPUFilterMode minFilter() const {
  return member_min_filter_;
}
void setMinFilter(V8GPUFilterMode value) {
  member_min_filter_ = value;
}
void setMinFilter(V8GPUFilterMode::Enum value) {
  member_min_filter_ = V8GPUFilterMode(value);
}

bool hasMipmapFilter() const {
  return true;
}
V8GPUMipmapFilterMode mipmapFilter() const {
  return member_mipmap_filter_;
}
void setMipmapFilter(V8GPUMipmapFilterMode value) {
  member_mipmap_filter_ = value;
}
void setMipmapFilter(V8GPUMipmapFilterMode::Enum value) {
  member_mipmap_filter_ = V8GPUMipmapFilterMode(value);
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = GPUObjectDescriptorBase::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 10;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_compare_ = false;

V8GPUAddressMode member_address_mode_u_{V8GPUAddressMode::Enum::kClampToEdge};
V8GPUAddressMode member_address_mode_v_{V8GPUAddressMode::Enum::kClampToEdge};
V8GPUAddressMode member_address_mode_w_{V8GPUAddressMode::Enum::kClampToEdge};
V8GPUCompareFunction member_compare_{static_cast<V8GPUCompareFunction::Enum>(0)};
float member_lod_max_clamp_{32};
float member_lod_min_clamp_{0};
V8GPUFilterMode member_mag_filter_{V8GPUFilterMode::Enum::kNearest};
uint16_t member_max_anisotropy_{1};
V8GPUFilterMode member_min_filter_{V8GPUFilterMode::Enum::kNearest};
V8GPUMipmapFilterMode member_mipmap_filter_{V8GPUMipmapFilterMode::Enum::kNearest};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_SAMPLER_DESCRIPTOR_H_
