// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_RENDER_PIPELINE_DESCRIPTOR_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_RENDER_PIPELINE_DESCRIPTOR_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_pipeline_descriptor_base.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class GPUDepthStencilState;
class GPUFragmentState;
class GPUMultisampleState;
class GPUPrimitiveState;
class GPUVertexState;

class MODULES_EXPORT GPURenderPipelineDescriptor : public GPUPipelineDescriptorBase {
  
  public:
static GPURenderPipelineDescriptor* Create() {
  return MakeGarbageCollected<GPURenderPipelineDescriptor>();
}
static GPURenderPipelineDescriptor* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<GPURenderPipelineDescriptor>(isolate);
}
static GPURenderPipelineDescriptor* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  GPURenderPipelineDescriptor();
explicit  GPURenderPipelineDescriptor(v8::Isolate* isolate);

bool hasDepthStencil() const {
  return has_depth_stencil_;
}
GPUDepthStencilState* depthStencil() const {
  DCHECK(hasDepthStencil());
return member_depth_stencil_.Get();
}
GPUDepthStencilState* getDepthStencilOr(GPUDepthStencilState* fallback_value) const {
  if (!hasDepthStencil()) {
  return fallback_value;
}
return member_depth_stencil_.Get();
}
void setDepthStencil(GPUDepthStencilState* value) {
  member_depth_stencil_ = value;
has_depth_stencil_ = true;
DCHECK(member_depth_stencil_);
}

bool hasFragment() const {
  return has_fragment_;
}
GPUFragmentState* fragment() const {
  DCHECK(hasFragment());
return member_fragment_.Get();
}
GPUFragmentState* getFragmentOr(GPUFragmentState* fallback_value) const {
  if (!hasFragment()) {
  return fallback_value;
}
return member_fragment_.Get();
}
void setFragment(GPUFragmentState* value) {
  member_fragment_ = value;
has_fragment_ = true;
DCHECK(member_fragment_);
}

bool hasMultisample() const {
  return true;
}
GPUMultisampleState* multisample() const {
  return member_multisample_.Get();
}
void setMultisample(GPUMultisampleState* value) {
  member_multisample_ = value;
DCHECK(member_multisample_);
}

bool hasPrimitive() const {
  return true;
}
GPUPrimitiveState* primitive() const {
  return member_primitive_.Get();
}
void setPrimitive(GPUPrimitiveState* value) {
  member_primitive_ = value;
DCHECK(member_primitive_);
}

bool hasVertex() const {
  return true;
}
GPUVertexState* vertex() const {
  return member_vertex_.Get();
}
void setVertex(GPUVertexState* value) {
  member_vertex_ = value;
DCHECK(member_vertex_);
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = GPUPipelineDescriptorBase::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 5;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_depth_stencil_ = false;
bool has_fragment_ = false;

Member<GPUDepthStencilState> member_depth_stencil_;
Member<GPUFragmentState> member_fragment_;
Member<GPUMultisampleState> member_multisample_;
Member<GPUPrimitiveState> member_primitive_;
Member<GPUVertexState> member_vertex_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_RENDER_PIPELINE_DESCRIPTOR_H_
