// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_RENDER_PASS_DESCRIPTOR_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_RENDER_PASS_DESCRIPTOR_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_object_descriptor_base.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class GPUQuerySet;
class GPURenderPassColorAttachment;
class GPURenderPassDepthStencilAttachment;
class GPURenderPassTimestampWrites;

class MODULES_EXPORT GPURenderPassDescriptor : public GPUObjectDescriptorBase {
  
  public:
static GPURenderPassDescriptor* Create() {
  return MakeGarbageCollected<GPURenderPassDescriptor>();
}
static GPURenderPassDescriptor* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<GPURenderPassDescriptor>(isolate);
}
static GPURenderPassDescriptor* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  GPURenderPassDescriptor();
explicit  GPURenderPassDescriptor(v8::Isolate* isolate);

bool hasColorAttachments() const {
  return true;
}
const HeapVector<Member<GPURenderPassColorAttachment>>& colorAttachments() const {
  return member_color_attachments_;
}
void setColorAttachments(const HeapVector<Member<GPURenderPassColorAttachment>>& value);
void setColorAttachments(HeapVector<Member<GPURenderPassColorAttachment>>&& value);

bool hasDepthStencilAttachment() const {
  return has_depth_stencil_attachment_;
}
GPURenderPassDepthStencilAttachment* depthStencilAttachment() const {
  DCHECK(hasDepthStencilAttachment());
return member_depth_stencil_attachment_.Get();
}
GPURenderPassDepthStencilAttachment* getDepthStencilAttachmentOr(GPURenderPassDepthStencilAttachment* fallback_value) const {
  if (!hasDepthStencilAttachment()) {
  return fallback_value;
}
return member_depth_stencil_attachment_.Get();
}
void setDepthStencilAttachment(GPURenderPassDepthStencilAttachment* value) {
  member_depth_stencil_attachment_ = value;
has_depth_stencil_attachment_ = true;
DCHECK(member_depth_stencil_attachment_);
}

bool hasMaxDrawCount() const {
  return has_max_draw_count_;
}
uint64_t maxDrawCount() const {
  DCHECK(hasMaxDrawCount());
return member_max_draw_count_;
}
uint64_t getMaxDrawCountOr(uint64_t fallback_value) const {
  if (!hasMaxDrawCount()) {
  return fallback_value;
}
return member_max_draw_count_;
}
void setMaxDrawCount(uint64_t value) {
  member_max_draw_count_ = value;
has_max_draw_count_ = true;
}

bool hasOcclusionQuerySet() const {
  return has_occlusion_query_set_;
}
GPUQuerySet* occlusionQuerySet() const {
  DCHECK(hasOcclusionQuerySet());
return member_occlusion_query_set_.Get();
}
GPUQuerySet* getOcclusionQuerySetOr(GPUQuerySet* fallback_value) const {
  if (!hasOcclusionQuerySet()) {
  return fallback_value;
}
return member_occlusion_query_set_.Get();
}
void setOcclusionQuerySet(GPUQuerySet* value) {
  member_occlusion_query_set_ = value;
has_occlusion_query_set_ = true;
DCHECK(member_occlusion_query_set_);
}

bool hasTimestampWrites() const {
  return has_timestamp_writes_;
}
GPURenderPassTimestampWrites* timestampWrites() const {
  DCHECK(hasTimestampWrites());
return member_timestamp_writes_.Get();
}
GPURenderPassTimestampWrites* getTimestampWritesOr(GPURenderPassTimestampWrites* fallback_value) const {
  if (!hasTimestampWrites()) {
  return fallback_value;
}
return member_timestamp_writes_.Get();
}
void setTimestampWrites(GPURenderPassTimestampWrites* value) {
  member_timestamp_writes_ = value;
has_timestamp_writes_ = true;
DCHECK(member_timestamp_writes_);
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = GPUObjectDescriptorBase::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 5;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_depth_stencil_attachment_ = false;
bool has_max_draw_count_ = false;
bool has_occlusion_query_set_ = false;
bool has_timestamp_writes_ = false;

HeapVector<Member<GPURenderPassColorAttachment>> member_color_attachments_;
Member<GPURenderPassDepthStencilAttachment> member_depth_stencil_attachment_;
uint64_t member_max_draw_count_;
Member<GPUQuerySet> member_occlusion_query_set_;
Member<GPURenderPassTimestampWrites> member_timestamp_writes_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_RENDER_PASS_DESCRIPTOR_H_
