// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_render_bundle_encoder.h"

#include "third_party/blink/public/mojom/origin_trials/origin_trial_feature.mojom-shared.h"
#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/is_return_type_compatible.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_set_return_value_for_core.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_bind_group.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_buffer.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_index_format.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_render_bundle.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_render_bundle_descriptor.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_render_pipeline.h"
#include "third_party/blink/renderer/core/execution_context/execution_context.h"
#include "third_party/blink/renderer/modules/webgpu/gpu_bind_group.h"
#include "third_party/blink/renderer/modules/webgpu/gpu_buffer.h"
#include "third_party/blink/renderer/modules/webgpu/gpu_render_bundle.h"
#include "third_party/blink/renderer/modules/webgpu/gpu_render_bundle_encoder.h"
#include "third_party/blink/renderer/modules/webgpu/gpu_render_pipeline.h"
#include "third_party/blink/renderer/platform/bindings/active_script_wrappable_base.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/idl_member_installer.h"
#include "third_party/blink/renderer/platform/bindings/runtime_call_stats.h"
#include "third_party/blink/renderer/platform/bindings/v8_binding.h"
#include "third_party/blink/renderer/platform/bindings/wrapper_type_info.h"

namespace blink {



bool V8GPURenderBundleEncoder::IsExposed(ExecutionContext* execution_context) {
  
const bool is_in_secure_context = execution_context->IsSecureContext();
return is_in_secure_context && (execution_context->IsWindow() || execution_context->IsWorkerGlobalScope());
}

// Construction of WrapperTypeInfo may require non-trivial initialization due
// to cross-component address resolution in order to load the pointer to the
// parent interface's WrapperTypeInfo.  We ignore this issue because the issue
// happens only on component builds and the official release builds
// (statically-linked builds) are never affected by this issue.
#if defined(COMPONENT_BUILD) && defined(WIN32) && defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wglobal-constructors"
#endif

const WrapperTypeInfo V8GPURenderBundleEncoder::wrapper_type_info_{
    {gin::kEmbedderBlink},
    V8GPURenderBundleEncoder::InstallInterfaceTemplate,
    nullptr,
    "GPURenderBundleEncoder",
    nullptr,
    V8GPURenderBundleEncoder::kThisTag,
    V8GPURenderBundleEncoder::kMaxSubclassTag,
    WrapperTypeInfo::kWrapperTypeObjectPrototype,
    WrapperTypeInfo::kObjectClassId,
    WrapperTypeInfo::kIdlInterface,
    false,
};

#if defined(COMPONENT_BUILD) && defined(WIN32) && defined(__clang__)
#pragma clang diagnostic pop
#endif

const WrapperTypeInfo& GPURenderBundleEncoder::wrapper_type_info_ =
    V8GPURenderBundleEncoder::wrapper_type_info_;

// non-[ActiveScriptWrappable]
static_assert(
    !std::is_base_of<ActiveScriptWrappableBase, GPURenderBundleEncoder>::value,
    "GPURenderBundleEncoder inherits from ActiveScriptWrappable<> without "
    "[ActiveScriptWrappable] extended attribute.");

namespace  {

namespace v8_gpu_render_bundle_encoder {


void LabelAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_GPURenderBundleEncoder_label_Getter");
BLINK_BINDINGS_TRACE_EVENT("GPURenderBundleEncoder.label.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
GPURenderBundleEncoder* blink_receiver = V8GPURenderBundleEncoder::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->label();
static_assert(bindings::IsReturnTypeCompatible<IDLUSVString, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNonNullable);
}

void LabelAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_GPURenderBundleEncoder_label_Setter");
BLINK_BINDINGS_TRACE_EVENT("GPURenderBundleEncoder.label.set");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
GPURenderBundleEncoder* blink_receiver = V8GPURenderBundleEncoder::ToWrappableUnsafe(isolate, v8_receiver);
v8::Local<v8::Value> v8_property_value = info[0];
ExceptionState exception_state(isolate);
auto&& arg1_value = NativeValueTraits<IDLUSVString>::NativeValue(isolate, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setLabel(arg1_value);

}

void DrawOperationNoAllocDirectCallArg4(v8::Local<v8::Object> v8_arg0_receiver, uint32_t v8_arg1_vertex_count, uint32_t v8_arg2_instance_count, uint32_t v8_arg3_first_vertex, uint32_t v8_arg4_first_instance, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
GPURenderBundleEncoder* blink_receiver = V8GPURenderBundleEncoder::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_vertex_count = v8_arg1_vertex_count;
auto&& arg2_instance_count = v8_arg2_instance_count;
auto&& arg3_first_vertex = v8_arg3_first_vertex;
auto&& arg4_first_instance = v8_arg4_first_instance;
blink_receiver->draw(arg1_vertex_count, arg2_instance_count, arg3_first_vertex, arg4_first_instance);
}

void DrawOperationNoAllocDirectCallArg3(v8::Local<v8::Object> v8_arg0_receiver, uint32_t v8_arg1_vertex_count, uint32_t v8_arg2_instance_count, uint32_t v8_arg3_first_vertex, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
GPURenderBundleEncoder* blink_receiver = V8GPURenderBundleEncoder::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_vertex_count = v8_arg1_vertex_count;
auto&& arg2_instance_count = v8_arg2_instance_count;
auto&& arg3_first_vertex = v8_arg3_first_vertex;
auto&& arg4_first_instance{0};
blink_receiver->draw(arg1_vertex_count, arg2_instance_count, arg3_first_vertex, arg4_first_instance);
}

void DrawOperationNoAllocDirectCallArg2(v8::Local<v8::Object> v8_arg0_receiver, uint32_t v8_arg1_vertex_count, uint32_t v8_arg2_instance_count, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
GPURenderBundleEncoder* blink_receiver = V8GPURenderBundleEncoder::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_vertex_count = v8_arg1_vertex_count;
auto&& arg2_instance_count = v8_arg2_instance_count;
auto&& arg3_first_vertex{0};
auto&& arg4_first_instance{0};
blink_receiver->draw(arg1_vertex_count, arg2_instance_count, arg3_first_vertex, arg4_first_instance);
}

void DrawOperationNoAllocDirectCallArg1(v8::Local<v8::Object> v8_arg0_receiver, uint32_t v8_arg1_vertex_count, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
GPURenderBundleEncoder* blink_receiver = V8GPURenderBundleEncoder::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_vertex_count = v8_arg1_vertex_count;
auto&& arg2_instance_count{1};
auto&& arg3_first_vertex{0};
auto&& arg4_first_instance{0};
blink_receiver->draw(arg1_vertex_count, arg2_instance_count, arg3_first_vertex, arg4_first_instance);
}

void DrawOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_GPURenderBundleEncoder_draw");
BLINK_BINDINGS_TRACE_EVENT("GPURenderBundleEncoder.draw");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
GPURenderBundleEncoder* blink_receiver = V8GPURenderBundleEncoder::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_vertex_count = NativeValueTraits<IDLUnsignedLongEnforceRange>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
decltype(NativeValueTraits<IDLUnsignedLongEnforceRange>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg2_instance_count{1};
if (!info[1]->IsUndefined()) {
  arg2_instance_count = NativeValueTraits<IDLUnsignedLongEnforceRange>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
decltype(NativeValueTraits<IDLUnsignedLongEnforceRange>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg3_first_vertex{0};
if (!info[2]->IsUndefined()) {
  arg3_first_vertex = NativeValueTraits<IDLUnsignedLongEnforceRange>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
decltype(NativeValueTraits<IDLUnsignedLongEnforceRange>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg4_first_instance{0};
if (!info[3]->IsUndefined()) {
  arg4_first_instance = NativeValueTraits<IDLUnsignedLongEnforceRange>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
blink_receiver->draw(arg1_vertex_count, arg2_instance_count, arg3_first_vertex, arg4_first_instance);

}

void DrawIndexedOperationNoAllocDirectCallArg5(v8::Local<v8::Object> v8_arg0_receiver, uint32_t v8_arg1_index_count, uint32_t v8_arg2_instance_count, uint32_t v8_arg3_first_index, int32_t v8_arg4_base_vertex, uint32_t v8_arg5_first_instance, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
GPURenderBundleEncoder* blink_receiver = V8GPURenderBundleEncoder::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_index_count = v8_arg1_index_count;
auto&& arg2_instance_count = v8_arg2_instance_count;
auto&& arg3_first_index = v8_arg3_first_index;
auto&& arg4_base_vertex = v8_arg4_base_vertex;
auto&& arg5_first_instance = v8_arg5_first_instance;
blink_receiver->drawIndexed(arg1_index_count, arg2_instance_count, arg3_first_index, arg4_base_vertex, arg5_first_instance);
}

void DrawIndexedOperationNoAllocDirectCallArg4(v8::Local<v8::Object> v8_arg0_receiver, uint32_t v8_arg1_index_count, uint32_t v8_arg2_instance_count, uint32_t v8_arg3_first_index, int32_t v8_arg4_base_vertex, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
GPURenderBundleEncoder* blink_receiver = V8GPURenderBundleEncoder::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_index_count = v8_arg1_index_count;
auto&& arg2_instance_count = v8_arg2_instance_count;
auto&& arg3_first_index = v8_arg3_first_index;
auto&& arg4_base_vertex = v8_arg4_base_vertex;
auto&& arg5_first_instance{0};
blink_receiver->drawIndexed(arg1_index_count, arg2_instance_count, arg3_first_index, arg4_base_vertex, arg5_first_instance);
}

void DrawIndexedOperationNoAllocDirectCallArg3(v8::Local<v8::Object> v8_arg0_receiver, uint32_t v8_arg1_index_count, uint32_t v8_arg2_instance_count, uint32_t v8_arg3_first_index, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
GPURenderBundleEncoder* blink_receiver = V8GPURenderBundleEncoder::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_index_count = v8_arg1_index_count;
auto&& arg2_instance_count = v8_arg2_instance_count;
auto&& arg3_first_index = v8_arg3_first_index;
auto&& arg4_base_vertex{0};
auto&& arg5_first_instance{0};
blink_receiver->drawIndexed(arg1_index_count, arg2_instance_count, arg3_first_index, arg4_base_vertex, arg5_first_instance);
}

void DrawIndexedOperationNoAllocDirectCallArg2(v8::Local<v8::Object> v8_arg0_receiver, uint32_t v8_arg1_index_count, uint32_t v8_arg2_instance_count, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
GPURenderBundleEncoder* blink_receiver = V8GPURenderBundleEncoder::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_index_count = v8_arg1_index_count;
auto&& arg2_instance_count = v8_arg2_instance_count;
auto&& arg3_first_index{0};
auto&& arg4_base_vertex{0};
auto&& arg5_first_instance{0};
blink_receiver->drawIndexed(arg1_index_count, arg2_instance_count, arg3_first_index, arg4_base_vertex, arg5_first_instance);
}

void DrawIndexedOperationNoAllocDirectCallArg1(v8::Local<v8::Object> v8_arg0_receiver, uint32_t v8_arg1_index_count, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
GPURenderBundleEncoder* blink_receiver = V8GPURenderBundleEncoder::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_index_count = v8_arg1_index_count;
auto&& arg2_instance_count{1};
auto&& arg3_first_index{0};
auto&& arg4_base_vertex{0};
auto&& arg5_first_instance{0};
blink_receiver->drawIndexed(arg1_index_count, arg2_instance_count, arg3_first_index, arg4_base_vertex, arg5_first_instance);
}

void DrawIndexedOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_GPURenderBundleEncoder_drawIndexed");
BLINK_BINDINGS_TRACE_EVENT("GPURenderBundleEncoder.drawIndexed");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
GPURenderBundleEncoder* blink_receiver = V8GPURenderBundleEncoder::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_index_count = NativeValueTraits<IDLUnsignedLongEnforceRange>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
decltype(NativeValueTraits<IDLUnsignedLongEnforceRange>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg2_instance_count{1};
if (!info[1]->IsUndefined()) {
  arg2_instance_count = NativeValueTraits<IDLUnsignedLongEnforceRange>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
decltype(NativeValueTraits<IDLUnsignedLongEnforceRange>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg3_first_index{0};
if (!info[2]->IsUndefined()) {
  arg3_first_index = NativeValueTraits<IDLUnsignedLongEnforceRange>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
decltype(NativeValueTraits<IDLLongEnforceRange>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg4_base_vertex{0};
if (!info[3]->IsUndefined()) {
  arg4_base_vertex = NativeValueTraits<IDLLongEnforceRange>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
decltype(NativeValueTraits<IDLUnsignedLongEnforceRange>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg5_first_instance{0};
if (!info[4]->IsUndefined()) {
  arg5_first_instance = NativeValueTraits<IDLUnsignedLongEnforceRange>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
blink_receiver->drawIndexed(arg1_index_count, arg2_instance_count, arg3_first_index, arg4_base_vertex, arg5_first_instance);

}

void DrawIndexedIndirectOperationNoAllocDirectCallArg2(v8::Local<v8::Object> v8_arg0_receiver, v8::Local<v8::Value> v8_arg1_indirect_buffer, uint64_t v8_arg2_indirect_offset, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);

v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
GPURenderBundleEncoder* blink_receiver = V8GPURenderBundleEncoder::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_indirect_buffer = NativeValueTraits<GPUBuffer>::ArgumentValue(isolate, 0, v8_arg1_indirect_buffer, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_indirect_offset = v8_arg2_indirect_offset;
blink_receiver->drawIndexedIndirect(arg1_indirect_buffer, arg2_indirect_offset);
}

void DrawIndexedIndirectOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_GPURenderBundleEncoder_drawIndexedIndirect");
BLINK_BINDINGS_TRACE_EVENT("GPURenderBundleEncoder.drawIndexedIndirect");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
GPURenderBundleEncoder* blink_receiver = V8GPURenderBundleEncoder::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_indirect_buffer = NativeValueTraits<GPUBuffer>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_indirect_offset = NativeValueTraits<IDLUnsignedLongLongEnforceRange>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->drawIndexedIndirect(arg1_indirect_buffer, arg2_indirect_offset);

}

void DrawIndirectOperationNoAllocDirectCallArg2(v8::Local<v8::Object> v8_arg0_receiver, v8::Local<v8::Value> v8_arg1_indirect_buffer, uint64_t v8_arg2_indirect_offset, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);

v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
GPURenderBundleEncoder* blink_receiver = V8GPURenderBundleEncoder::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_indirect_buffer = NativeValueTraits<GPUBuffer>::ArgumentValue(isolate, 0, v8_arg1_indirect_buffer, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_indirect_offset = v8_arg2_indirect_offset;
blink_receiver->drawIndirect(arg1_indirect_buffer, arg2_indirect_offset);
}

void DrawIndirectOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_GPURenderBundleEncoder_drawIndirect");
BLINK_BINDINGS_TRACE_EVENT("GPURenderBundleEncoder.drawIndirect");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
GPURenderBundleEncoder* blink_receiver = V8GPURenderBundleEncoder::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_indirect_buffer = NativeValueTraits<GPUBuffer>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_indirect_offset = NativeValueTraits<IDLUnsignedLongLongEnforceRange>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->drawIndirect(arg1_indirect_buffer, arg2_indirect_offset);

}

void FinishOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_GPURenderBundleEncoder_finish");
BLINK_BINDINGS_TRACE_EVENT("GPURenderBundleEncoder.finish");






v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
GPURenderBundleEncoder* blink_receiver = V8GPURenderBundleEncoder::ToWrappableUnsafe(isolate, v8_receiver);
decltype(NativeValueTraits<GPURenderBundleDescriptor>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg1_descriptor;
if (info[0]->IsUndefined()) {
  arg1_descriptor = GPURenderBundleDescriptor::Create();
} else {
  ExceptionState exception_state(isolate);
arg1_descriptor = NativeValueTraits<GPURenderBundleDescriptor>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
auto&& return_value = blink_receiver->finish(arg1_descriptor);
static_assert(bindings::IsReturnTypeCompatible<GPURenderBundle, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}

void InsertDebugMarkerOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_GPURenderBundleEncoder_insertDebugMarker");
BLINK_BINDINGS_TRACE_EVENT("GPURenderBundleEncoder.insertDebugMarker");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
GPURenderBundleEncoder* blink_receiver = V8GPURenderBundleEncoder::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_marker_label = NativeValueTraits<IDLUSVString>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->insertDebugMarker(arg1_marker_label);

}

void PopDebugGroupOperationNoAllocDirectCallArg0(v8::Local<v8::Object> v8_arg0_receiver, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
GPURenderBundleEncoder* blink_receiver = V8GPURenderBundleEncoder::ToWrappableUnsafe(isolate, v8_receiver);
blink_receiver->popDebugGroup();
}

void PopDebugGroupOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_GPURenderBundleEncoder_popDebugGroup");
BLINK_BINDINGS_TRACE_EVENT("GPURenderBundleEncoder.popDebugGroup");






v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
GPURenderBundleEncoder* blink_receiver = V8GPURenderBundleEncoder::ToWrappableUnsafe(isolate, v8_receiver);
blink_receiver->popDebugGroup();

}

void PushDebugGroupOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_GPURenderBundleEncoder_pushDebugGroup");
BLINK_BINDINGS_TRACE_EVENT("GPURenderBundleEncoder.pushDebugGroup");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
GPURenderBundleEncoder* blink_receiver = V8GPURenderBundleEncoder::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_group_label = NativeValueTraits<IDLUSVString>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->pushDebugGroup(arg1_group_label);

}

void SetBindGroupOperationNoAllocDirectCallOverload1Arg3(v8::Local<v8::Object> v8_arg0_receiver, uint32_t v8_arg1_index, v8::Local<v8::Value> v8_arg2_bind_group, v8::Local<v8::Value> v8_arg3_dynamic_offsets, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);


v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
GPURenderBundleEncoder* blink_receiver = V8GPURenderBundleEncoder::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_index = v8_arg1_index;
ExceptionState exception_state(isolate);
auto&& arg2_bind_group = NativeValueTraits<IDLNullable<GPUBindGroup>>::ArgumentValue(isolate, 1, v8_arg2_bind_group, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_dynamic_offsets = NativeValueTraits<IDLSequence<IDLUnsignedLongEnforceRange>>::ArgumentValue(isolate, 2, v8_arg3_dynamic_offsets, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setBindGroup(arg1_index, arg2_bind_group, arg3_dynamic_offsets);
}

void SetBindGroupOperationNoAllocDirectCallOverload1Arg2(v8::Local<v8::Object> v8_arg0_receiver, uint32_t v8_arg1_index, v8::Local<v8::Value> v8_arg2_bind_group, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);

v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
GPURenderBundleEncoder* blink_receiver = V8GPURenderBundleEncoder::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_index = v8_arg1_index;
ExceptionState exception_state(isolate);
auto&& arg2_bind_group = NativeValueTraits<IDLNullable<GPUBindGroup>>::ArgumentValue(isolate, 1, v8_arg2_bind_group, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setBindGroup(arg1_index, arg2_bind_group);
}

void SetBindGroupOperationNoAllocDirectCallOverload2Arg5(v8::Local<v8::Object> v8_arg0_receiver, uint32_t v8_arg1_index, v8::Local<v8::Value> v8_arg2_bind_group, v8::Local<v8::Value> v8_arg3_dynamic_offsets_data, uint64_t v8_arg4_dynamic_offsets_data_start, uint32_t v8_arg5_dynamic_offsets_data_length, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);



v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
GPURenderBundleEncoder* blink_receiver = V8GPURenderBundleEncoder::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_index = v8_arg1_index;
ExceptionState exception_state(isolate);
auto&& arg2_bind_group = NativeValueTraits<IDLNullable<GPUBindGroup>>::ArgumentValue(isolate, 1, v8_arg2_bind_group, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_dynamic_offsets_data = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowShared, uint32_t>>::ArgumentValue(isolate, 2, v8_arg3_dynamic_offsets_data, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_dynamic_offsets_data_start = v8_arg4_dynamic_offsets_data_start;
auto&& arg5_dynamic_offsets_data_length = v8_arg5_dynamic_offsets_data_length;
blink_receiver->setBindGroup(arg1_index, arg2_bind_group, arg3_dynamic_offsets_data, arg4_dynamic_offsets_data_start, arg5_dynamic_offsets_data_length, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}

void SetBindGroupOperationOverload1(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


if (info.Length() < 2) [[unlikely]] {
  v8::Isolate* isolate = info.GetIsolate();
V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


do {  // Dummy loop for use of 'break'.
  const int non_undefined_argument_length = bindings::NonUndefinedArgumentLength(info);
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
GPURenderBundleEncoder* blink_receiver = V8GPURenderBundleEncoder::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_index = NativeValueTraits<IDLUnsignedLongEnforceRange>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_bind_group = NativeValueTraits<IDLNullable<GPUBindGroup>>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
if (non_undefined_argument_length <= 2) {
  blink_receiver->setBindGroup(arg1_index, arg2_bind_group);
break;
}
auto&& arg3_dynamic_offsets = NativeValueTraits<IDLSequence<IDLUnsignedLongEnforceRange>>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setBindGroup(arg1_index, arg2_bind_group, std::move(arg3_dynamic_offsets));
} while (false);

}

void SetBindGroupOperationOverload2(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 5) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(5, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
GPURenderBundleEncoder* blink_receiver = V8GPURenderBundleEncoder::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_index = NativeValueTraits<IDLUnsignedLongEnforceRange>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_bind_group = NativeValueTraits<IDLNullable<GPUBindGroup>>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_dynamic_offsets_data = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowShared, uint32_t>>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_dynamic_offsets_data_start = NativeValueTraits<IDLUnsignedLongLongEnforceRange>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_dynamic_offsets_data_length = NativeValueTraits<IDLUnsignedLongEnforceRange>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setBindGroup(arg1_index, arg2_bind_group, arg3_dynamic_offsets_data, arg4_dynamic_offsets_data_start, arg5_dynamic_offsets_data_length, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}

void SetBindGroupOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_GPURenderBundleEncoder_setBindGroup");
BLINK_BINDINGS_TRACE_EVENT("GPURenderBundleEncoder.setBindGroup");


const int arg_count = std::min(info.Length(), 5);
if (arg_count == 5) {
  return SetBindGroupOperationOverload2(info);
}
if (arg_count == 3) {
  return SetBindGroupOperationOverload1(info);
}
if (arg_count == 2) {
  return SetBindGroupOperationOverload1(info);
}

v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}
V8ThrowException::ThrowTypeError(isolate, "Overload resolution failed.");
return;
}

void SetIndexBufferOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_GPURenderBundleEncoder_setIndexBuffer");
BLINK_BINDINGS_TRACE_EVENT("GPURenderBundleEncoder.setIndexBuffer");




if (info.Length() < 2) [[unlikely]] {
  v8::Isolate* isolate = info.GetIsolate();
V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


do {  // Dummy loop for use of 'break'.
  const int non_undefined_argument_length = bindings::NonUndefinedArgumentLength(info);
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
GPURenderBundleEncoder* blink_receiver = V8GPURenderBundleEncoder::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_buffer = NativeValueTraits<GPUBuffer>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_format = NativeValueTraits<V8GPUIndexFormat>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
decltype(NativeValueTraits<IDLUnsignedLongLongEnforceRange>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg3_offset{0};
if (!info[2]->IsUndefined()) {
  arg3_offset = NativeValueTraits<IDLUnsignedLongLongEnforceRange>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
if (non_undefined_argument_length <= 3) {
  blink_receiver->setIndexBuffer(arg1_buffer, arg2_format, arg3_offset);
break;
}
auto&& arg4_size = NativeValueTraits<IDLUnsignedLongLongEnforceRange>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setIndexBuffer(arg1_buffer, arg2_format, arg3_offset, arg4_size);
} while (false);

}

void SetPipelineOperationNoAllocDirectCallArg1(v8::Local<v8::Object> v8_arg0_receiver, v8::Local<v8::Value> v8_arg1_pipeline, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);

v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
GPURenderBundleEncoder* blink_receiver = V8GPURenderBundleEncoder::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_pipeline = NativeValueTraits<GPURenderPipeline>::ArgumentValue(isolate, 0, v8_arg1_pipeline, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setPipeline(arg1_pipeline);
}

void SetPipelineOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_GPURenderBundleEncoder_setPipeline");
BLINK_BINDINGS_TRACE_EVENT("GPURenderBundleEncoder.setPipeline");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
GPURenderBundleEncoder* blink_receiver = V8GPURenderBundleEncoder::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_pipeline = NativeValueTraits<GPURenderPipeline>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setPipeline(arg1_pipeline);

}

void SetVertexBufferOperationNoAllocDirectCallArg4(v8::Local<v8::Object> v8_arg0_receiver, uint32_t v8_arg1_slot, v8::Local<v8::Value> v8_arg2_buffer, uint64_t v8_arg3_offset, uint64_t v8_arg4_size, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);

v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
GPURenderBundleEncoder* blink_receiver = V8GPURenderBundleEncoder::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_slot = v8_arg1_slot;
ExceptionState exception_state(isolate);
auto&& arg2_buffer = NativeValueTraits<IDLNullable<GPUBuffer>>::ArgumentValue(isolate, 1, v8_arg2_buffer, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_offset = v8_arg3_offset;
auto&& arg4_size = v8_arg4_size;
blink_receiver->setVertexBuffer(arg1_slot, arg2_buffer, arg3_offset, arg4_size);
}

void SetVertexBufferOperationNoAllocDirectCallArg3(v8::Local<v8::Object> v8_arg0_receiver, uint32_t v8_arg1_slot, v8::Local<v8::Value> v8_arg2_buffer, uint64_t v8_arg3_offset, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);

v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
GPURenderBundleEncoder* blink_receiver = V8GPURenderBundleEncoder::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_slot = v8_arg1_slot;
ExceptionState exception_state(isolate);
auto&& arg2_buffer = NativeValueTraits<IDLNullable<GPUBuffer>>::ArgumentValue(isolate, 1, v8_arg2_buffer, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_offset = v8_arg3_offset;
blink_receiver->setVertexBuffer(arg1_slot, arg2_buffer, arg3_offset);
}

void SetVertexBufferOperationNoAllocDirectCallArg2(v8::Local<v8::Object> v8_arg0_receiver, uint32_t v8_arg1_slot, v8::Local<v8::Value> v8_arg2_buffer, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);

v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
GPURenderBundleEncoder* blink_receiver = V8GPURenderBundleEncoder::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_slot = v8_arg1_slot;
ExceptionState exception_state(isolate);
auto&& arg2_buffer = NativeValueTraits<IDLNullable<GPUBuffer>>::ArgumentValue(isolate, 1, v8_arg2_buffer, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_offset{0};
blink_receiver->setVertexBuffer(arg1_slot, arg2_buffer, arg3_offset);
}

void SetVertexBufferOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_GPURenderBundleEncoder_setVertexBuffer");
BLINK_BINDINGS_TRACE_EVENT("GPURenderBundleEncoder.setVertexBuffer");




if (info.Length() < 2) [[unlikely]] {
  v8::Isolate* isolate = info.GetIsolate();
V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


do {  // Dummy loop for use of 'break'.
  const int non_undefined_argument_length = bindings::NonUndefinedArgumentLength(info);
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
GPURenderBundleEncoder* blink_receiver = V8GPURenderBundleEncoder::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_slot = NativeValueTraits<IDLUnsignedLongEnforceRange>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_buffer = NativeValueTraits<IDLNullable<GPUBuffer>>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
decltype(NativeValueTraits<IDLUnsignedLongLongEnforceRange>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg3_offset{0};
if (!info[2]->IsUndefined()) {
  arg3_offset = NativeValueTraits<IDLUnsignedLongLongEnforceRange>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
if (non_undefined_argument_length <= 3) {
  blink_receiver->setVertexBuffer(arg1_slot, arg2_buffer, arg3_offset);
break;
}
auto&& arg4_size = NativeValueTraits<IDLUnsignedLongLongEnforceRange>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setVertexBuffer(arg1_slot, arg2_buffer, arg3_offset, arg4_size);
} while (false);

}


}  // namespace v8_gpu_render_bundle_encoder

using namespace v8_gpu_render_bundle_encoder;

}  // namespace 

void V8GPURenderBundleEncoder::InstallInterfaceTemplate(v8::Isolate* isolate, const DOMWrapperWorld& world, v8::Local<v8::Template> interface_template) {
  const WrapperTypeInfo* const wrapper_type_info = V8GPURenderBundleEncoder::GetWrapperTypeInfo();
v8::Local<v8::FunctionTemplate> interface_function_template = interface_template.As<v8::FunctionTemplate>();
v8::Local<v8::ObjectTemplate> instance_template = interface_function_template->InstanceTemplate();
v8::Local<v8::ObjectTemplate> prototype_template = interface_function_template->PrototypeTemplate();
v8::Local<v8::FunctionTemplate> parent_interface_template;
bindings::SetupIDLInterfaceTemplate(isolate, wrapper_type_info, instance_template, prototype_template, interface_function_template, parent_interface_template);






InstallUnconditionalProperties(isolate, world, instance_template, prototype_template, interface_template);
}

void V8GPURenderBundleEncoder::InstallUnconditionalProperties(v8::Isolate* isolate, const DOMWrapperWorld& world, v8::Local<v8::ObjectTemplate> instance_template, v8::Local<v8::ObjectTemplate> prototype_template, v8::Local<v8::Template> interface_template) {
  using bindings::IDLMemberInstaller;

v8::Local<v8::Signature> signature = v8::Local<v8::Signature>::Cast(interface_template);
{
  
static const IDLMemberInstaller::AttributeConfig kAttributeTable[] = {
{"label", LabelAttributeGetCallback, LabelAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
};
IDLMemberInstaller::InstallAttributes(isolate, world, instance_template, prototype_template, interface_template, signature, "GPURenderBundleEncoder", kAttributeTable);
}





{
  static const IDLMemberInstaller::OperationConfig kOperationTable[] = {
{"finish", FinishOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"insertDebugMarker", InsertDebugMarkerOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"pushDebugGroup", PushDebugGroupOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"setIndexBuffer", SetIndexBufferOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
};
IDLMemberInstaller::InstallOperations(isolate, world, instance_template, prototype_template, interface_template, signature, "GPURenderBundleEncoder", kOperationTable);
}


{
  // Disable [NoAllocDirectCall] on x86 due to https://crbug.com/1433212
#if defined(ARCH_CPU_X86)
static const IDLMemberInstaller::OperationConfig kOperationTable[] = {
{"draw", DrawOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"drawIndexed", DrawIndexedOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"drawIndexedIndirect", DrawIndexedIndirectOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"drawIndirect", DrawIndirectOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"popDebugGroup", PopDebugGroupOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"setBindGroup", SetBindGroupOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"setPipeline", SetPipelineOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"setVertexBuffer", SetVertexBufferOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
};
// Disable compiler warnings for unused functions.
std::ignore = DrawOperationNoAllocDirectCallArg4;
std::ignore = DrawOperationNoAllocDirectCallArg3;
std::ignore = DrawOperationNoAllocDirectCallArg2;
std::ignore = DrawOperationNoAllocDirectCallArg1;
std::ignore = DrawIndexedOperationNoAllocDirectCallArg5;
std::ignore = DrawIndexedOperationNoAllocDirectCallArg4;
std::ignore = DrawIndexedOperationNoAllocDirectCallArg3;
std::ignore = DrawIndexedOperationNoAllocDirectCallArg2;
std::ignore = DrawIndexedOperationNoAllocDirectCallArg1;
std::ignore = DrawIndexedIndirectOperationNoAllocDirectCallArg2;
std::ignore = DrawIndirectOperationNoAllocDirectCallArg2;
std::ignore = PopDebugGroupOperationNoAllocDirectCallArg0;
std::ignore = SetBindGroupOperationNoAllocDirectCallOverload1Arg3;
std::ignore = SetBindGroupOperationNoAllocDirectCallOverload1Arg2;
std::ignore = SetBindGroupOperationNoAllocDirectCallOverload2Arg5;
std::ignore = SetPipelineOperationNoAllocDirectCallArg1;
std::ignore = SetVertexBufferOperationNoAllocDirectCallArg4;
std::ignore = SetVertexBufferOperationNoAllocDirectCallArg3;
std::ignore = SetVertexBufferOperationNoAllocDirectCallArg2;
#else   // defined(ARCH_CPU_X86)
static const v8::CFunction kNoAllocDirectCallOverloadsOfDraw[] = {
v8::CFunctionBuilder().Fn(DrawOperationNoAllocDirectCallArg4).Arg<1, v8::CTypeInfo::Flags::kEnforceRangeBit>().Arg<2, v8::CTypeInfo::Flags::kEnforceRangeBit>().Arg<3, v8::CTypeInfo::Flags::kEnforceRangeBit>().Arg<4, v8::CTypeInfo::Flags::kEnforceRangeBit>().Build(),
v8::CFunctionBuilder().Fn(DrawOperationNoAllocDirectCallArg3).Arg<1, v8::CTypeInfo::Flags::kEnforceRangeBit>().Arg<2, v8::CTypeInfo::Flags::kEnforceRangeBit>().Arg<3, v8::CTypeInfo::Flags::kEnforceRangeBit>().Build(),
v8::CFunctionBuilder().Fn(DrawOperationNoAllocDirectCallArg2).Arg<1, v8::CTypeInfo::Flags::kEnforceRangeBit>().Arg<2, v8::CTypeInfo::Flags::kEnforceRangeBit>().Build(),
v8::CFunctionBuilder().Fn(DrawOperationNoAllocDirectCallArg1).Arg<1, v8::CTypeInfo::Flags::kEnforceRangeBit>().Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfDrawIndexed[] = {
v8::CFunctionBuilder().Fn(DrawIndexedOperationNoAllocDirectCallArg5).Arg<1, v8::CTypeInfo::Flags::kEnforceRangeBit>().Arg<2, v8::CTypeInfo::Flags::kEnforceRangeBit>().Arg<3, v8::CTypeInfo::Flags::kEnforceRangeBit>().Arg<4, v8::CTypeInfo::Flags::kEnforceRangeBit>().Arg<5, v8::CTypeInfo::Flags::kEnforceRangeBit>().Build(),
v8::CFunctionBuilder().Fn(DrawIndexedOperationNoAllocDirectCallArg4).Arg<1, v8::CTypeInfo::Flags::kEnforceRangeBit>().Arg<2, v8::CTypeInfo::Flags::kEnforceRangeBit>().Arg<3, v8::CTypeInfo::Flags::kEnforceRangeBit>().Arg<4, v8::CTypeInfo::Flags::kEnforceRangeBit>().Build(),
v8::CFunctionBuilder().Fn(DrawIndexedOperationNoAllocDirectCallArg3).Arg<1, v8::CTypeInfo::Flags::kEnforceRangeBit>().Arg<2, v8::CTypeInfo::Flags::kEnforceRangeBit>().Arg<3, v8::CTypeInfo::Flags::kEnforceRangeBit>().Build(),
v8::CFunctionBuilder().Fn(DrawIndexedOperationNoAllocDirectCallArg2).Arg<1, v8::CTypeInfo::Flags::kEnforceRangeBit>().Arg<2, v8::CTypeInfo::Flags::kEnforceRangeBit>().Build(),
v8::CFunctionBuilder().Fn(DrawIndexedOperationNoAllocDirectCallArg1).Arg<1, v8::CTypeInfo::Flags::kEnforceRangeBit>().Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfDrawIndexedIndirect[] = {
v8::CFunctionBuilder().Fn(DrawIndexedIndirectOperationNoAllocDirectCallArg2).Arg<2, v8::CTypeInfo::Flags::kEnforceRangeBit>().Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfDrawIndirect[] = {
v8::CFunctionBuilder().Fn(DrawIndirectOperationNoAllocDirectCallArg2).Arg<2, v8::CTypeInfo::Flags::kEnforceRangeBit>().Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfPopDebugGroup[] = {
v8::CFunctionBuilder().Fn(PopDebugGroupOperationNoAllocDirectCallArg0).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfSetBindGroup[] = {
v8::CFunctionBuilder().Fn(SetBindGroupOperationNoAllocDirectCallOverload1Arg3).Arg<1, v8::CTypeInfo::Flags::kEnforceRangeBit>().Build(),
v8::CFunctionBuilder().Fn(SetBindGroupOperationNoAllocDirectCallOverload1Arg2).Arg<1, v8::CTypeInfo::Flags::kEnforceRangeBit>().Build(),
v8::CFunctionBuilder().Fn(SetBindGroupOperationNoAllocDirectCallOverload2Arg5).Arg<1, v8::CTypeInfo::Flags::kEnforceRangeBit>().Arg<4, v8::CTypeInfo::Flags::kEnforceRangeBit>().Arg<5, v8::CTypeInfo::Flags::kEnforceRangeBit>().Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfSetPipeline[] = {
v8::CFunctionBuilder().Fn(SetPipelineOperationNoAllocDirectCallArg1).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfSetVertexBuffer[] = {
v8::CFunctionBuilder().Fn(SetVertexBufferOperationNoAllocDirectCallArg4).Arg<1, v8::CTypeInfo::Flags::kEnforceRangeBit>().Arg<3, v8::CTypeInfo::Flags::kEnforceRangeBit>().Arg<4, v8::CTypeInfo::Flags::kEnforceRangeBit>().Build(),
v8::CFunctionBuilder().Fn(SetVertexBufferOperationNoAllocDirectCallArg3).Arg<1, v8::CTypeInfo::Flags::kEnforceRangeBit>().Arg<3, v8::CTypeInfo::Flags::kEnforceRangeBit>().Build(),
v8::CFunctionBuilder().Fn(SetVertexBufferOperationNoAllocDirectCallArg2).Arg<1, v8::CTypeInfo::Flags::kEnforceRangeBit>().Build(),
};

static const IDLMemberInstaller::NoAllocDirectCallOperationConfig kOperationTable[] = {
{{"draw", DrawOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfDraw, std::size(kNoAllocDirectCallOverloadsOfDraw)}, 
{{"drawIndexed", DrawIndexedOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfDrawIndexed, std::size(kNoAllocDirectCallOverloadsOfDrawIndexed)}, 
{{"drawIndexedIndirect", DrawIndexedIndirectOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfDrawIndexedIndirect, std::size(kNoAllocDirectCallOverloadsOfDrawIndexedIndirect)}, 
{{"drawIndirect", DrawIndirectOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfDrawIndirect, std::size(kNoAllocDirectCallOverloadsOfDrawIndirect)}, 
{{"popDebugGroup", PopDebugGroupOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfPopDebugGroup, std::size(kNoAllocDirectCallOverloadsOfPopDebugGroup)}, 
{{"setBindGroup", SetBindGroupOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfSetBindGroup, std::size(kNoAllocDirectCallOverloadsOfSetBindGroup)}, 
{{"setPipeline", SetPipelineOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfSetPipeline, std::size(kNoAllocDirectCallOverloadsOfSetPipeline)}, 
{{"setVertexBuffer", SetVertexBufferOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfSetVertexBuffer, std::size(kNoAllocDirectCallOverloadsOfSetVertexBuffer)}, 
};
#endif  // defined(ARCH_CPU_X86)
IDLMemberInstaller::InstallOperations(isolate, world, instance_template, prototype_template, interface_template, signature, "GPURenderBundleEncoder", kOperationTable);
}


}




}  // namespace blink
