// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_RASTERIZATION_STATE_DESCRIPTOR_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_RASTERIZATION_STATE_DESCRIPTOR_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_cull_mode.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_front_face.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT GPURasterizationStateDescriptor : public bindings::DictionaryBase {
  
  public:
static GPURasterizationStateDescriptor* Create() {
  return MakeGarbageCollected<GPURasterizationStateDescriptor>();
}
static GPURasterizationStateDescriptor* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<GPURasterizationStateDescriptor>(isolate);
}
static GPURasterizationStateDescriptor* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  GPURasterizationStateDescriptor();
explicit  GPURasterizationStateDescriptor(v8::Isolate* isolate);

bool hasCullMode() const {
  return true;
}
V8GPUCullMode cullMode() const {
  return member_cull_mode_;
}
void setCullMode(V8GPUCullMode value) {
  member_cull_mode_ = value;
}
void setCullMode(V8GPUCullMode::Enum value) {
  member_cull_mode_ = V8GPUCullMode(value);
}

bool hasDepthBias() const {
  return true;
}
int32_t depthBias() const {
  return member_depth_bias_;
}
void setDepthBias(int32_t value) {
  member_depth_bias_ = value;
}

bool hasDepthBiasClamp() const {
  return true;
}
float depthBiasClamp() const {
  return member_depth_bias_clamp_;
}
void setDepthBiasClamp(float value) {
  member_depth_bias_clamp_ = value;
}

bool hasDepthBiasSlopeScale() const {
  return true;
}
float depthBiasSlopeScale() const {
  return member_depth_bias_slope_scale_;
}
void setDepthBiasSlopeScale(float value) {
  member_depth_bias_slope_scale_ = value;
}

bool hasFrontFace() const {
  return true;
}
V8GPUFrontFace frontFace() const {
  return member_front_face_;
}
void setFrontFace(V8GPUFrontFace value) {
  member_front_face_ = value;
}
void setFrontFace(V8GPUFrontFace::Enum value) {
  member_front_face_ = V8GPUFrontFace(value);
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 5;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



V8GPUCullMode member_cull_mode_{V8GPUCullMode::Enum::kNone};
int32_t member_depth_bias_{0};
float member_depth_bias_clamp_{0};
float member_depth_bias_slope_scale_{0};
V8GPUFrontFace member_front_face_{V8GPUFrontFace::Enum::kCcw};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_RASTERIZATION_STATE_DESCRIPTOR_H_
