// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_PROGRAMMABLE_STAGE_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_PROGRAMMABLE_STAGE_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;
class GPUShaderModule;

class MODULES_EXPORT GPUProgrammableStage : public bindings::InputDictionaryBase {
  
  public:
static GPUProgrammableStage* Create() {
  return MakeGarbageCollected<GPUProgrammableStage>();
}
static GPUProgrammableStage* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<GPUProgrammableStage>(isolate);
}
static GPUProgrammableStage* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  GPUProgrammableStage();
explicit  GPUProgrammableStage(v8::Isolate* isolate);

bool hasConstants() const {
  return has_constants_;
}
const Vector<std::pair<String, double>>& constants() const {
  DCHECK(hasConstants());
return member_constants_;
}
Vector<std::pair<String, double>> getConstantsOr(const Vector<std::pair<String, double>>& fallback_value) const;
Vector<std::pair<String, double>> getConstantsOr(Vector<std::pair<String, double>>&& fallback_value) const;
void setConstants(const Vector<std::pair<String, double>>& value);
void setConstants(Vector<std::pair<String, double>>&& value);

bool hasEntryPoint() const {
  return has_entry_point_;
}
const String& entryPoint() const {
  DCHECK(hasEntryPoint());
return member_entry_point_;
}
String getEntryPointOr(const String& fallback_value) const;
String getEntryPointOr(String&& fallback_value) const;
void setEntryPoint(const String& value);
void setEntryPoint(String&& value);

bool hasModule() const {
  return true;
}
GPUShaderModule* module() const {
  return member_module_.Get();
}
void setModule(GPUShaderModule* value) {
  member_module_ = value;
DCHECK(member_module_);
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 3;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_constants_ = false;
bool has_entry_point_ = false;

Vector<std::pair<String, double>> member_constants_;
String member_entry_point_;
Member<GPUShaderModule> member_module_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_PROGRAMMABLE_STAGE_H_
