// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_programmable_stage.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/modules/webgpu/gpu_shader_module.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"constants",
"entryPoint",
"module",
};


}  // namespace 

GPUProgrammableStage* GPUProgrammableStage::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  GPUProgrammableStage* dictionary = MakeGarbageCollected<GPUProgrammableStage>(isolate);
if (!v8_value->IsObject()) {
  const char* const class_like_name = "GPUProgrammableStage";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 GPUProgrammableStage::GPUProgrammableStage() {
  
}

 GPUProgrammableStage::GPUProgrammableStage(v8::Isolate* isolate) {
  
}



Vector<std::pair<String, double>> GPUProgrammableStage::getConstantsOr(const Vector<std::pair<String, double>>& fallback_value) const {
  if (!hasConstants()) {
  return fallback_value;
}
return member_constants_;
}

Vector<std::pair<String, double>> GPUProgrammableStage::getConstantsOr(Vector<std::pair<String, double>>&& fallback_value) const {
  if (!hasConstants()) {
  return std::move(fallback_value);
}
return member_constants_;
}

void GPUProgrammableStage::setConstants(const Vector<std::pair<String, double>>& value) {
  member_constants_ = value;
has_constants_ = true;
}

void GPUProgrammableStage::setConstants(Vector<std::pair<String, double>>&& value) {
  member_constants_ = std::move(value);
has_constants_ = true;
}




String GPUProgrammableStage::getEntryPointOr(const String& fallback_value) const {
  if (!hasEntryPoint()) {
  return fallback_value;
}
return member_entry_point_;
}

String GPUProgrammableStage::getEntryPointOr(String&& fallback_value) const {
  if (!hasEntryPoint()) {
  return std::move(fallback_value);
}
return member_entry_point_;
}

void GPUProgrammableStage::setEntryPoint(const String& value) {
  member_entry_point_ = value;
has_entry_point_ = true;
}

void GPUProgrammableStage::setEntryPoint(String&& value) {
  member_entry_point_ = std::move(value);
has_entry_point_ = true;
}









void GPUProgrammableStage::Trace(Visitor* visitor) const {
  visitor->Trace(member_module_);
bindings::InputDictionaryBase::Trace(visitor);
}

void GPUProgrammableStage::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "GPUProgrammableStage";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("constants");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<IDLRecord<IDLUSVString, IDLDouble>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_constants_, member_constants_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("entryPoint");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUSVString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_entry_point_, member_entry_point_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("module");
constexpr bool is_required = true;
bool fallback_presence_var;
if (!bindings::GetDictionaryMemberFromV8Object<GPUShaderModule, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), fallback_presence_var, member_module_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> GPUProgrammableStage::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
